<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		news
 */


class Hook_projects
{

	/**
	 * Standard modular run function for finding news authors. This hook will return a list of news authors to auto fill text box.
	 *
	 * @param  ID_TEXT	The search key word
	 * @return string		Options list
	 */
	function get_values($search_key)
	{
		//Find field type
		$sql="SELECT t1.id,t1.cf_name,t1.cf_type,t2.text_original FROM ".get_table_prefix()."catalogue_fields t1,".get_table_prefix()."translate t2 WHERE t1.c_name='projects' AND t1.cf_name=t2.id and t2.text_original='Project title'";

		$row	=	$GLOBALS['SITE_DB']->query($sql);
		if(!array_key_exists(0,$row)) return false;

		$field	=	$row[0];

		require_code('catalogues');
		$res	=	$GLOBALS['SITE_DB']->query("SELECT DISTINCT cv_value,SUBSTRING(cv_value,1,CHAR_LENGTH('".$search_key."')) as fldval FROM ".get_table_prefix()."catalogue_efv_short WHERE cf_id=".strval($field['id'])." AND cv_value LIKE '%".db_escape_string($search_key)."%' ORDER BY FIELD(fldval,'".$search_key."') DESC");

		if(!array_key_exists(0,$res)) return false;

		$out	=	NULL;
		foreach($res as $entry)
		{
			$out	.= $entry['cv_value']."\n";
		}
		echo $out;
	}
}


