<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		news
 */


class Hook_location
{

	/**
	 * Standard modular run function for finding news authors. This hook will return a list of news authors to auto fill text box.
	 *
	 * @param  ID_TEXT	The search key word
	 * @return string		Options list
	 */
	function get_values($search_key,$field_name,$r_fld=NULL,$r_fld_val=NULL)
	{
		$where		=	(!is_null($r_fld_val) && $r_fld_val!='')?"AND ".db_string_equal_to($r_fld,$r_fld_val):'';

		$res	=	$GLOBALS['FORUM_DB']->query("SELECT DISTINCT ".db_escape_string($field_name)." as $field_name,SUBSTRING(".$field_name.",1,CHAR_LENGTH('".db_escape_string($search_key)."')) as fldval FROM ".get_table_prefix()."locations WHERE ".db_escape_string($field_name)." LIKE '%".db_escape_string($search_key)."%' $where ORDER BY FIELD(fldval,'".db_escape_string($search_key)."') DESC LIMIT 10");

		$out	=	NULL;
		if(!array_key_exists(0,$res)) return;

		foreach($res as $value)
		{
			$out	.= ucfirst(strtolower($value[$field_name]))."\n";
		}

		echo $out;
	}
}


