<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		news
 */


class Hook_cpf
{

	/**
	 * Standard modular run function for finding news authors. This hook will return a list of news authors to auto fill text box.
	 *
	 * @param  ID_TEXT	The search key word
	 * @return string		Options list
	 */
	function get_values($search_key,$field_name,$r_fld=NULL,$r_fld_val=NULL)
	{
		$field_name	=	$this->get_field_name($field_name);
		$rel_fielf	=	(!is_null($r_fld))?$this->get_field_name($r_fld):NULL;

		$where		=	(!is_null($rel_fielf)?"AND ".db_string_equal_to($rel_fielf,$r_fld_val):'');

		$res	=	$GLOBALS['FORUM_DB']->query("SELECT DISTINCT ".$field_name." as $field_name,SUBSTRING(".$field_name.",1,CHAR_LENGTH('".$search_key."')) as fldval FROM ".get_table_prefix()."f_member_custom_fields WHERE ".$field_name." LIKE '%".db_escape_string($search_key)."%' $where ORDER BY FIELD(fldval,'".$search_key."') DESC");

		$out	=	NULL;
		if(!array_key_exists(0,$res)) return;

		foreach($res as $value)
		{
			$out	.= $value[$field_name]."\n";
		}

		echo $out;
	}

	/**
	 * Function to return db's custom field name of cpf
	 *
	 * @param  ID_TEXT	Cpf name
	 * @return ID_TEXT?	Field name/NULL
	 */
	function get_field_name($cpf_name)
	{
		$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".db_escape_string($cpf_name)."'";

		$row=$GLOBALS['SITE_DB']->query($sql);
		if(!array_key_exists(0,$row)) return;
		return 'field_'.$row[0]['id'];
	}
}


