<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		galleries
 */

class Hook_search_videos
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		if (!module_installed('galleries')) return NULL;

		if (!has_actual_page_access(get_member(),'galleries')) return NULL;

		require_lang('galleries');

		$info=array();
		$info['lang']=do_lang_tempcode('VIDEOS');
		$info['default']=true;
		$info['category']='cat';
		$info['integer_category']=false;
		$info['extra_sort_fields']=array('video_length'=>do_lang_tempcode('VIDEO_LENGTH'));

		return $info;
	}

	/**
	 * Get a list of extra fields to ask for.
	 *
	 * @return array			A list of maps specifying extra fields
	 */
	function get_fields()
	{
		$fields=array();

		$awards=$GLOBALS['SITE_DB']->query_select('award_types',array('*'),array('a_content_type'=>'video'));
		foreach ($awards as $award_row)
		{
			$fields[]=array('NAME'=>'award_'.strval($award_row['id']),'DISPLAY'=>get_translated_text($award_row['a_title']),'TYPE'=>'_TICK','SPECIAL'=>'');
		}

		return $fields;
	}

	/**
	 * Get details for an ajax-tree-list of entries for the content covered by this search hook.
	 *
	 * @return array			A pair: the hook, and the options
	 */
	function ajax_tree()
	{
		return array('choose_gallery',array('compound_list'=>true));
	}

	/**
	 * Standard modular run function for search results.
	 *
	 * @param  array			A list of words for the boolean search
	 * @param  boolean		Whether to only do a META (tags) search
	 * @param  ID_TEXT		Order direction
	 * @param  integer		Start position in total results
	 * @param  integer		Maximum results to return in total
	 * @param  boolean		Whether only to search titles (as opposed to both titles and content)
	 * @param  string			Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
	 * @param  SHORT_TEXT	Username/Author to match for
	 * @param  ?MEMBER		Member-ID to match for (NULL: unknown)
	 * @param  TIME			Cutoff date
	 * @param  string			The sort type (gets remapped to a field in this function)
	 * @set    title add_date
	 * @param  integer		Limit to this number of results
	 * @param  string			What kind of boolean search to do
	 * @set    or and
	 * @param  string			Where constraints known by the main search code (SQL query fragment)
	 * @param  string			Comma-separated list of categories to search under
	 * @param  BINARY			Whether it is a boolean search
	 * @return array			List of maps (template, orderer)
	 */
	function run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$limit_to,$boolean_operator,$where_clause,$search_under,$boolean_search)
	{
		unset($limit_to);
		unset($boolean_operator);

		$remapped_orderer='';
		switch ($sort)
		{
			case 'rating':
				$remapped_orderer='_rating:videos:id';
				break;

			case 'title':
				$remapped_orderer='comments';
				break;

			case 'add_date':
				$remapped_orderer='add_date';
				break;

			case 'video_length':
				$remapped_orderer=$sort;
				break;
		}

		require_lang('galleries');

		// Calculate our where clause (search)
		$sq=build_search_submitter_clauses('submitter',$author_id,$author);
		if (is_null($sq)) return array(); else $where_clause.=$sq;
		if (!is_null($cutoff))
		{
			$where_clause.=' AND ';
			$where_clause.='add_date>'.strval($cutoff);
		}

		if (!has_specific_permission(get_member(),'see_unvalidated'))
		{
			$where_clause.=' AND ';
			$where_clause.='validated=1';
		}

		$table='videos r';

		$awards=$GLOBALS['SITE_DB']->query_select('award_types',array('*'),array('a_content_type'=>'video'));
		foreach ($awards as $i=>$award_row)
		{
			if (get_param_integer('option_award_'.strval($award_row['id']),0)==1)
			{
				$table.=' JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'award_archive g'.strval($i).' ON (g'.strval($i).'.content_id=r.id AND g'.strval($i).'.a_type_id='.strval($award_row['id']).')';
				$where_clause.=' AND ';
				$where_clause.='g'.strval($i).'.content_id IS NOT NULL';
			}
		}

		// Calculate and perform query
		$rows=get_search_rows('video','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table,array('','r.comments'),$where_clause,$content_where,$remapped_orderer,'r.*',array('r.title'),NULL,'cat',true);

		$out=array();
		foreach ($rows as $i=>$row)
		{
			$out[$i]['data']=$row;
			unset($rows[$i]);
			if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
		}

		return $out;
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return tempcode	The output
	 */
	function render($row)
	{
		require_code('images');
		$url=build_url(array('page'=>'galleries','type'=>'video','id'=>$row['id']),get_module_zone('galleries'));
		$thumb_url=ensure_thumbnail($row['url'],$row['thumb_url'],'galleries','videos',$row['id']);

		$tpl=hyperlink($url,do_image_thumb($thumb_url,get_translated_tempcode($row['comments']),true));
		require_code('galleries');
		$tree=gallery_breadcrumbs($row['cat'],'root',false);
		$tpl->attach(paragraph(do_lang_tempcode('LOCATED_IN',$tree)));
		return put_in_standard_box($tpl,do_lang_tempcode('VIDEO'));
	}

}


