<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_ocf
 */

class Hook_search_ocf_members
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		if (get_forum_type()!='ocf') return NULL;

		require_lang('ocf');

		$info=array();
		$info['lang']=do_lang_tempcode('MEMBERS');
		$info['default']=false;
		$info['special_on']=array();
		$info['special_off']=array();
		$info['user_label']=do_lang_tempcode('USERNAME');
		$info['days_label']=do_lang_tempcode('JOINED_AGO');

		$extra_sort_fields=array();
		if (has_specific_permission(get_member(),'view_profiles'))
		{
			require_code('ocf_members');
			$rows=ocf_get_all_custom_fields_match(NULL,1,1);
			foreach ($rows as $row)
			{
				$extra_sort_fields['field_'.strval($row['id'])]=$row['trans_name'];
			}
		}
		$info['extra_sort_fields']=$extra_sort_fields;

		return $info;
	}

	/**
	 * Get a list of extra fields to ask for.
	 *
	 * @return array			A list of maps specifying extra fields
	 */
	function get_fields()
	{
		require_code('ocf_members');

		$fields=array();
		if (has_specific_permission(get_member(),'view_profiles'))
		{
			$rows=ocf_get_all_custom_fields_match(NULL,1,1);
			foreach ($rows as $row)
			{
				$type='_TEXT';
				$special=make_string_tempcode(get_param('option_'.strval($row['id']),''));
				if (substr($row['cf_type'],-4)=='list')
				{
					$type='_LIST';
					$special=form_input_list_entry('',true,'---');
					$list=explode('|',$row['cf_default']);
					foreach ($list as $l)
					{
						$special->attach(form_input_list_entry($l,$l==get_param('option_'.strval($row['id']),'')));
					}
				}
				$display=$row['trans_name'];
				$fields[]=array('NAME'=>strval($row['id']),'DISPLAY'=>$display,'TYPE'=>$type,'SPECIAL'=>$special);
			}

			$fields[]=array('NAME'=>'_age_range','DISPLAY'=>do_lang_tempcode('AGE_RANGE'),'TYPE'=>'_TEXT','SPECIAL'=>'');
		}

		$map=has_specific_permission(get_member(),'see_hidden_groups')?NULL:array('g_hidden'=>0);
		$rows=$GLOBALS['FORUM_DB']->query_select('f_groups g LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t ON '.db_string_equal_to('language',user_lang()).' AND t.id=g.g_name',array('g.id','text_original','g.g_name'),$map);
		$groups=form_input_list_entry('',true,'---');
		$default_group=get_param('group','');
		$group_titles=array();
		foreach ($rows as $row)
		{
			if (is_null($row['text_original'])) $row['text_original']=get_translated_text($row['g_name'],$GLOBALS['FORUM_DB']);

			if ($row['id']==db_get_first_id()) continue;
			$groups->attach(form_input_list_entry(strval($row['id']),strval($row['id'])==$default_group,$row['text_original']));
			$group_titles[$row['id']]=$row['text_original'];
		}
		if (strpos($default_group,',')!==false)
		{
			$bits=explode(',',$default_group);
			$combination=new ocp_tempcode();
			foreach ($bits as $bit)
			{
				if (!$combination->is_empty()) $combination->attach(do_lang_tempcode('LIST_SEP'));
				$combination->attach(escape_html(@$group_titles[intval($bit)]));
			}
			$groups->attach(form_input_list_entry(strval($default_group),true,do_lang_tempcode('USERGROUP_SEARCH_COMBO',escape_html($combination))));
		}
		$fields[]=array('NAME'=>'_user_group','DISPLAY'=>do_lang_tempcode('GROUP'),'TYPE'=>'_LIST','SPECIAL'=>$groups);
		if (has_specific_permission(get_member(),'see_hidden_groups'))
//      $fields[]=array('NAME'=>'_photo_thumb_url','DISPLAY'=>do_lang('PHOTO'),'TYPE'=>'','SPECIAL'=>'','CHECKED'=>false);
		{
			//$fields[]=array('NAME'=>'_emails_only','DISPLAY'=>do_lang_tempcode('EMAILS_ONLY'),'TYPE'=>'_TICK','SPECIAL'=>'');	CSV export better now
		}

		return $fields;
	}

	/**
	 * Standard modular run function for search results.
	 *
	 * @param  array			A list of words for the boolean search
	 * @param  boolean		Whether to only do a META (tags) search
	 * @param  ID_TEXT		Order direction
	 * @param  integer		Start position in total results
	 * @param  integer		Maximum results to return in total
	 * @param  boolean		Whether only to search titles (as opposed to both titles and content)
	 * @param  string			Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
	 * @param  SHORT_TEXT	Username/Author to match for
	 * @param  ?MEMBER		Member-ID to match for (NULL: unknown)
	 * @param  TIME			Cutoff date
	 * @param  string			The sort type (gets remapped to a field in this function)
	 * @set    title add_date
	 * @param  integer		Limit to this number of results
	 * @param  string			What kind of boolean search to do
	 * @set    or and
	 * @param  string			Where constraints known by the main search code (SQL query fragment)
	 * @param  string			Comma-separated list of categories to search under
	 * @param  BINARY			Whether it is a boolean search
	 * @return array			List of maps (template, orderer)
	 */
	function run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$limit_to,$boolean_operator,$where_clause,$search_under,$boolean_search)
	{
		unset($limit_to);
		unset($boolean_operator);

		if (get_forum_type()!='ocf') return array();
		require_code('ocf_members');

		$remapped_orderer='';
		switch ($sort)
		{
			case 'title':
				$remapped_orderer='m_username';
				break;

			case 'add_date':
				$remapped_orderer='m_join_time';
				break;

			case 'relevance':
			case 'rating':
				break;

			default:
				$remapped_orderer=$sort;
				break;
		}

		require_lang('ocf');

		// Calculate our where clause (search)
		if ($author!='')
		{
			$where_clause.=' AND ';
			$where_clause.=db_string_equal_to('m_username',$author);
		}
		if (!is_null($cutoff))
		{
			$where_clause.=' AND ';
			$where_clause.='m_join_time>'.strval($cutoff);
		}
		$raw_fields=array('m_username');
		$trans_fields=array();
		$rows=ocf_get_all_custom_fields_match(NULL,1,1);
		$table='';
		foreach ($rows as $i=>$row)
		{
			$param=get_param('option_'.strval($row['id']),'');
			if ($param!='')
			{
				$where_clause.=' AND ';

				if (($row['cf_type']=='short_trans') || ($row['cf_type']=='long_trans'))
				{
					$where_clause.='t'.strval($i).'.text_original LIKE \''.db_encode_like('%'.$param.'%').'\'';
					$table.=' LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'translate t'.strval($i).' ON field_'.strval($row['id']).'=t'.strval($i).'.id';
				} else
				{
					$where_clause.='field_'.strval($row['id']).' LIKE \''.db_encode_like('%'.$param.'%').'\'';
				}
			}
			if (($row['cf_type']!='short_trans') && ($row['cf_type']!='long_trans') && ($row['cf_type']!='integer') && ($row['cf_type']!='tick') && ($row['cf_type']!='float'))
				$raw_fields[]='field_'.strval($row['id']);
			elseif (($row['cf_type']=='short_trans') || ($row['cf_type']=='long_trans'))
				$trans_fields[]='field_'.strval($row['id']);
		}
		$age_range=get_param('option__age_range','');
		if ($age_range!='')
		{
			$bits=explode('-',$age_range);
			if (count($bits)==2)
			{
				$where_clause.=' AND ';
				$lower=strval(intval(date('Y',servertime_to_usertime()))-intval($bits[0]));
				$upper=strval(intval(date('Y',servertime_to_usertime()))-intval($bits[1]));
				$where_clause.='m_dob_year<'.strval($lower).' AND m_dob_year>'.strval($upper).' AND (m_dob_year IS NOT NULL)';
			}
			if (either_param_integer('option__photo_thumb_url',0)==1)
			{
				$where_clause.=' AND ';
				$where_clause.=db_string_not_equal_to('m_photo_thumb_url','');
			}
		}
		$user_group=get_param('option__user_group','');
		if ($user_group!='')
		{
			$bits=explode(',',$user_group);
			$where_clause.=' AND ';
			$group_where_clause='';
			foreach ($bits as $i=>$bit)
			{
				$group=intval($bit);
				$table.=' LEFT JOIN '.$GLOBALS['FORUM_DB']->get_table_prefix().'f_group_members g'.strval($i).' ON (g'.strval($i).'.gm_group_id='.strval($group).' AND g'.strval($i).'.gm_member_id=r.id)';
				if ($group_where_clause!='') $group_where_clause.=' OR ';
				$group_where_clause.='g'.strval($i).'.gm_validated=1 OR m_primary_group='.strval($group);
			}
			$where_clause.='('.$group_where_clause.')';
		}

		$tbl_prefix	=	$GLOBALS['FORUM_DB']->get_table_prefix();

		//Default field values
		$defaults	=	array('ocp_firstname'=>'First name','ocp_lastname'=>'Last name','ocp_city'=>'City','ocp_state'=>'State','Genre'=>'','Instruments'=>'Instruments','Influences'=>'Influences','Band members'=>'Band members','Company name'=>'Company name','Talent type'=>'Talent type','Gender'=>'Gender','Age range'=>'Age range','Hair color'=>'Hair color','Ethnicity'=>'Ethnicity','Gigs'=>'Gigs','IDMB link'=>'IDMB link','Special skills'=>'Special skills','Job title'=>'Job title','Language'=>'Language','Writing style'=>'Writing style','Photography style'=>'Photography style','Union'=>'Union');

		$matching_fields['ocp_firstname']	=	get_param('first_name',NULL);
		$matching_fields['ocp_lastname']	=	get_param('last_name',NULL);
		$matching_fields['ocp_city']	=	get_param('city',NULL);
		$matching_fields['ocp_state']	=	get_param('state',NULL);

		//---	Advanced search fields	-----------------
		$group		=	get_param('option__user_group','');

		switch($group)
		{
			//Group conditions for artist search
			case 'Musician / Solo artist':
					$matching_fields['Genre']			=	get_param('genre',NULL);
					$matching_fields['Instruments']	=	get_param('instruments',NULL);
					$matching_fields['Gigs']			=	get_param('gigs',NULL);
				break;
			case 'Film talent':
					$matching_fields['Talent type']	=	get_param('talent_type',NULL);
					$matching_fields['Gender']			=	get_param('gender',NULL);
					$matching_fields['Age range']		=	get_param('age_range',NULL);
					$matching_fields['Hair color']	=	get_param('hair_color',NULL);
					$matching_fields['Ethnicity']		=	get_param('ethnicity',NULL);
					$matching_fields['IDMB link']	=	get_param('idmb_link',NULL);
					$matching_fields['Special skills']	=	get_param('special_skills',NULL);
				break;
			case 'Band':
					$matching_fields['Instruments']	=	get_param('instruments',NULL);
					$matching_fields['Influences']	=	get_param('influences',NULL);
					$matching_fields['Band members']	=	get_param('band_members',NULL);
					$matching_fields['Gigs']			=	get_param('gigs',NULL);
				break;
			case	'Film crew':
					$matching_fields['Job title']			=	get_param('job_title',NULL);
					$matching_fields['Language']			=	get_param('language',NULL);
					$matching_fields['Union']				=	get_param('union',NULL);
					$matching_fields['Special skills']	=	get_param('special_skills',NULL);
				break;
			case	'Producers / Directors':
					$matching_fields['IDMB link']			=	get_param('idmb_link',NULL);
					$matching_fields['Company name']		=	get_param('company_name',NULL);
					break;
			case	'Photographer':
					$matching_fields['Photography style']	=	get_param('photography_style',NULL);
				break;
			case	'Writer / Author':
					$matching_fields['Writing style']	=	get_param('writing_style',NULL);
					$matching_fields['Genre']				=	get_param('writer_genre',NULL);
					$matching_fields['Union']				=	get_param('writer_union',NULL);
				break;
			case	'Handcrafted / Visual art':
		}

		$where_conds	=	NULL;

		foreach($matching_fields as $field_name=>$field_val)
		{
			if($defaults[$field_name]==$field_val || $field_val=='') continue;

			$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".$field_name."'";

			$row=$GLOBALS['SITE_DB']->query($sql);
			if(!array_key_exists(0,$row)) continue;

			$fields[]['field_'.$row[0]['id']]=$field_val;
			$act_field		=	'field_'.$row[0]['id'];
			$where_conds	.=	" AND a.".$act_field." LIKE '%".db_escape_string($field_val)."%'";
		}

		$table_query	=	'f_members r RIGHT JOIN '.get_table_prefix().'f_member_custom_fields a ON r.id=a.mf_member_id'.$table.$where_conds;

		// Calculate and perform query
		$rows=get_search_rows(NULL,NULL,$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table_query,array('!','m_signature')+$trans_fields,$where_clause,$content_where,$remapped_orderer,'*,r.id AS id',$raw_fields);

		$out=array();
		foreach ($rows as $i=>$row)
		{
			/*if ($user_group!='')
			{
				$bits=explode(',',$user_group);
				$ok=false;
				$groups=$GLOBALS['FORUM_DRIVER']->get_members_groups($row['id']);
				foreach ($bits as $bit)
				{
					if (in_array($user_group,$groups)) $ok=true;
				}
				if (!$ok) continue;
			}*/

			$out[$i]['data']=$row;
			unset($rows[$i]);
			if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
		}

		return $out;
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return tempcode	The output
	 */
	function render($row)
	{
		require_code('ocf_members');
		if (get_param_integer('option__emails_only',0)==1)
		{
			$link=hyperlink($GLOBALS['FORUM_DRIVER']->member_profile_link($row['id']),$row['m_username'],false,true);
			$link2=($row['m_email_address']=='')?new ocp_tempcode():hyperlink('mailto: '.$row['m_email_address'],$row['m_email_address'],false,true);
			return paragraph($link->evaluate().' &lt;'.$link2->evaluate().'&gt;','e3f;l23kf;l320932kl');
		}
		require_code('ocf_members2');
		return ocf_get_member_html($row);
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return array		The output
	 */
	function render_tabular($row)
	{
		$member_id		=	$row['id'];
		if(is_null($member_id) or is_guest($member_id))	return;
		$avatar=new ocp_tempcode();
		$avatar_url		=	$GLOBALS['OCF_DRIVER']->get_member_avatar_url($member_id);
		$artist_name	=	$GLOBALS['OCF_DRIVER']->get_username($member_id);
		if ($avatar_url!='')
		{
			$avatar=do_template('OCF_TOPIC_POST_AVATAR',array('AVATAR'=>$avatar_url));
		}
		$username=$GLOBALS['OCF_DRIVER']->get_username($member_id);

		$profile_url	=	get_search_result_url($GLOBALS['FORUM_DRIVER']->member_profile_link($member_id,true));
		$member_url		=	hyperlink($profile_url,$artist_name);

		$cpf_data		=	ocf_get_custom_field_mappings($member_id);
		$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND (t1.text_original='ocp_state' OR t1.text_original='ocp_city')";
		$res			=	$GLOBALS['SITE_DB']->query($sql);
		$location	=	array();
		foreach($res as $locations)
		{
			$field_name	=	'field_'.$locations['id'];
			if($cpf_data[$field_name]!='')	$location[]	=	$cpf_data[$field_name];
		}

		$member_loc	=	array_key_exists(0,$location)?implode(", ",$location):'-';
		$view_url	=	hyperlink($profile_url,'View');

		$artist_type		=	$GLOBALS['FORUM_DB']->query_value('f_groups','g_name',array('id'=>$row['m_primary_group']));

		return array(''=>$avatar,'Artist'=>$member_url,'Type'=>get_translated_text($artist_type),'Location'=>$member_loc,'View'=>$view_url);
	}
}


