<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		news
 */

class Hook_search_news
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		if (!module_installed('news')) return NULL;

		if (!has_actual_page_access(get_member(),'news')) return NULL;

		require_lang('news');

		$info=array();
		$info['lang']=do_lang_tempcode('NEWS');
		$info['default']=true;
		$info['category']='news_category';
		$info['integer_category']=true;

		return $info;
	}

	/**
	 * Get a list of entries for the content covered by this search hook. In hierarchical list selection format.
	 *
	 * @param  string			The default selected item
	 * @return tempcode		Tree structure
	 */
	function get_tree($_selected)
	{
		$selected=intval($_selected);

		require_code('news');

		$tree=nice_get_news_categories($selected);
		return $tree;
	}

	/**
	 * Standard modular run function for search results.
	 *
	 * @param  array			A list of words for the boolean search
	 * @param  boolean		Whether to only do a META (tags) search
	 * @param  ID_TEXT		Order direction
	 * @param  integer		Start position in total results
	 * @param  integer		Maximum results to return in total
	 * @param  boolean		Whether only to search titles (as opposed to both titles and content)
	 * @param  string			Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
	 * @param  SHORT_TEXT	Username/Author to match for
	 * @param  ?MEMBER		Member-ID to match for (NULL: unknown)
	 * @param  TIME			Cutoff date
	 * @param  string			The sort type (gets remapped to a field in this function)
	 * @set    title add_date
	 * @param  integer		Limit to this number of results
	 * @param  string			What kind of boolean search to do
	 * @set    or and
	 * @param  string			Where constraints known by the main search code (SQL query fragment)
	 * @param  string			Comma-separated list of categories to search under
	 * @param  BINARY			Whether it is a boolean search
	 * @return array			List of maps (template, orderer)
	 */
	function run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$limit_to,$boolean_operator,$where_clause,$search_under,$boolean_search)
	{
		unset($limit_to);
		unset($boolean_operator);

		$remapped_orderer='';
		switch ($sort)
		{
			case 'rating':
				$remapped_orderer='_rating:news:id';
				break;

			case 'title':
				$remapped_orderer='title';
				break;

			case 'add_date':
				$remapped_orderer='date_and_time';
				break;
		}

		require_code('news');
		require_lang('news');
		require_css('news');

		// Calculate our where clause (search)
		$sq=build_search_submitter_clauses('submitter',$author_id,$author,'author');
		if (is_null($sq)) return array(); else $where_clause.=$sq;
		if (!is_null($cutoff))
		{
			$where_clause.=' AND ';
			$where_clause.='date_and_time>'.strval((integer)$cutoff);
		}

		if (!has_specific_permission(get_member(),'see_unvalidated'))
		{
			$where_clause.=' AND ';
			$where_clause.='validated=1';
		}

// 		if(!is_null(get_param('news_submitter',NULL)) && get_param('news_submitter')!='Submitter name')
// 		{
// 			$submitter	=	get_param('news_submitter','');
// 			$where_clause	.=	" AND fm.m_username LIKE '".db_encode_like('%'.$submitter.'%')."'";
// 		}

		if(get_param('news_category','')!='')
		{
			$news_category	 =	get_param('news_category');
			$where_clause	.=	" AND r.news_category=".$news_category."";
		}

		//Default field values
		$defaults	=	array('ocp_firstname'=>'First name','ocp_lastname'=>'Last name');
		$matching_fields['ocp_firstname']	=	get_param('first_name',NULL);
		$matching_fields['ocp_lastname']		=	get_param('last_name',NULL);

		$tables	=	"news r LEFT JOIN ".$GLOBALS['FORUM_DB']->get_table_prefix()."f_members fm ON r.submitter=fm.id";

		foreach($matching_fields as $field_name=>$field_val)
		{
			if($defaults[$field_name]==$field_val || $field_val=='') continue;

			$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".$field_name."'";

			$row=$GLOBALS['SITE_DB']->query($sql);
			if(!array_key_exists(0,$row)) continue;

			$fields[]['field_'.$row[0]['id']]=$field_val;
			$act_field		=	'field_'.$row[0]['id'];

			$where_clause	.=	" AND mcf.".$act_field." LIKE '%".db_escape_string($field_val)."%'";
		}

		$tables	.=	" RIGHT JOIN ".$GLOBALS['FORUM_DB']->get_table_prefix()."f_member_custom_fields mcf ON fm.id = mcf.mf_member_id";

		// Calculate and perform query
		$rows=get_search_rows('news','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$tables,array('r.title','r.news','r.news_article'),$where_clause,$content_where,$remapped_orderer,'r.*',NULL,'news','news_category');

		$out=array();
		foreach ($rows as $i=>$row)
		{
			$out[$i]['data']=$row;
			unset($rows[$i]);
			if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
		}

		return $out;
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return tempcode	The output
	 */
	function render($myrow)
	{
		if($myrow['id']=='' || is_null($myrow['id']))	return;
		global $NEWS_CATS;
		if (!isset($NEWS_CATS))
		{
			$NEWS_CATS=$GLOBALS['SITE_DB']->query_select('news_categories',array('*'));
			$NEWS_CATS=list_to_map('id',$NEWS_CATS);
		}

		$id=$myrow['id'];
		$date=get_timezoned_date($myrow['date_and_time']);
		$author_url=addon_installed('authors')?get_search_result_url(build_url(array('page'=>'authors','type'=>'misc','id'=>$myrow['author']),get_module_zone('authors'))):new ocp_tempcode();
		$author=$myrow['author'];
		$news_title=get_translated_tempcode($myrow['title']);
		$tmp=array('page'=>'news','type'=>'view','id'=>$id);
		$full_url=build_url($tmp,get_module_zone('news'));
		$view_url	=	hyperlink(get_search_result_url($full_url),'View');

		$img=find_theme_image($NEWS_CATS[$myrow['news_category']]['nc_img']);
		if (is_null($img)) $img='';
		$img	=	new ocp_tempcode();
		if ($myrow['news_image']!='')
		{
			$img=$myrow['news_image'];
			if (url_is_local($img)) $img=get_base_url().'/'.$img;
		}
		$author_url	=	hyperlink($author_url,$author);
		return array(''=>$img,'Headline'=>$news_title,'Creator'=>$author_url,'Date'=>$date,'View'=>$view_url);
	}
}


