<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		galleries
 */

class Hook_search_galleries
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		if (!module_installed('galleries')) return NULL;

		require_lang('galleries');

		$info=array();
		$info['lang']=do_lang_tempcode('GALLERIES');
		$info['default']=true;

		return $info;
	}

	/**
	 * Standard modular run function for search results.
	 *
	 * @param  array			A list of words for the boolean search
	 * @param  boolean		Whether to only do a META (tags) search
	 * @param  ID_TEXT		Order direction
	 * @param  integer		Start position in total results
	 * @param  integer		Maximum results to return in total
	 * @param  boolean		Whether only to search titles (as opposed to both titles and content)
	 * @param  string			Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
	 * @param  SHORT_TEXT	Username/Author to match for
	 * @param  ?MEMBER		Member-ID to match for (NULL: unknown)
	 * @param  TIME			Cutoff date
	 * @param  string			The sort type (gets remapped to a field in this function)
	 * @set    title add_date
	 * @param  integer		Limit to this number of results
	 * @param  string			What kind of boolean search to do
	 * @set    or and
	 * @param  string			Where constraints known by the main search code (SQL query fragment)
	 * @param  string			Comma-separated list of categories to search under
	 * @param  BINARY			Whether it is a boolean search
	 * @return array			List of maps (template, orderer)
	 */
	function run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$limit_to,$boolean_operator,$where_clause,$search_under,$boolean_search)
	{
		unset($author_id);
		unset($limit_to);
		unset($boolean_operator);

		$remapped_orderer='';
		switch ($sort)
		{
			case 'rating':
				$remapped_orderer='_rating:galleries:name';
				break;

			case 'title':
				$remapped_orderer='r.fullname';
				break;

			case 'add_date':
				$remapped_orderer='r.add_date';
				break;
		}

		require_lang('galleries');

		// Calculate our where clause (search)
		if ($author!='')
		{
			return array();
		}
		if (!is_null($cutoff))
		{
			$where_clause.=' AND ';
			$where_clause.='r.add_date>'.strval($cutoff);
		}

		$where_clause.=' AND ';
		$where_clause.='r.name NOT LIKE \''.db_encode_like('download\_%').'\'';

		$tbl_prefix	=	$GLOBALS['FORUM_DB']->get_table_prefix();

		//Default field values
		$defaults	=	array('ocp_firstname'=>'First name','ocp_lastname'=>'Last name','ocp_city'=>'City','ocp_state'=>'State','Genre'=>'','Instruments'=>'Instruments','Influences'=>'Influences','Band members'=>'Band members','Company name'=>'Company name','Talent type'=>'Talent type','Gender'=>'Gender','Age'=>'Age range','Hair color'=>'Hair color','Ethnicity'=>'Ethnicity','Gigs'=>'Gigs','IDMB link'=>'IDMB link','Special skills'=>'Special skills','Job title'=>'Job title','Language'=>'Language','Writing style'=>'Writing style','Photography style'=>'Photography style','Union'=>'Union');

		$matching_fields['ocp_firstname']	=	get_param('first_name',NULL);
		$matching_fields['ocp_lastname']	=	get_param('last_name',NULL);
		$matching_fields['ocp_city']	=	get_param('city',NULL);
		$matching_fields['ocp_state']	=	get_param('state',NULL);

		//---	Advanced search fields	-----------------
		$art_type		=	get_param('art_types','');

		switch($art_type)
		{
			case 'music':
					$matching_fields['Genre']			=	get_param('genre',NULL);
					$matching_fields['Instruments']	=	get_param('instruments',NULL);
					$matching_fields['Influences']	=	get_param('influences',NULL);
					$matching_fields['Band members']	=	get_param('band_members',NULL);
				break;
			case	'film':
					$matching_fields['Company name']	=	get_param('company_name',NULL);
					$matching_fields['Talent type']	=	get_param('talent_type',NULL);
					$matching_fields['Gender']			=	get_param('gender',NULL);
					$matching_fields['Age']		=	get_param('age_range',NULL);
					$matching_fields['Hair color']	=	get_param('hair_color',NULL);
					$matching_fields['Ethnicity']		=	get_param('ethnicity',NULL);
				break;
			case	'photography':
					$matching_fields['Photography style']	=	get_param('photography_style',NULL);
				break;
			case	'writing':
					$matching_fields['Writing style']	=	get_param('writing_style',NULL);
				break;
			case	'handcrafted':
				break;
			case	'fine_art':
				break;
		}

		$where_conds	=	NULL;

		foreach($matching_fields as $field_name=>$field_val)
		{
			if($defaults[$field_name]==$field_val || $field_val=='') continue;

			$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".$field_name."'";

			$row=$GLOBALS['SITE_DB']->query($sql);
			if(!array_key_exists(0,$row)) continue;

			$fields[]['field_'.$row[0]['id']]=$field_val;
			$act_field		=	'field_'.$row[0]['id'];

			if($field_name=='Age')
			{
				$bits=explode('-',$field_val);
				if (count($bits)==2)
				{
					$where_clause.=' AND ';
					$lower=strval(intval(date('Y',servertime_to_usertime()))-intval($bits[0]));
					$upper=strval(intval(date('Y',servertime_to_usertime()))-intval($bits[1]));
					$where_clause.='fm.m_dob_year<'.strval($lower).' AND fm.m_dob_year>'.strval($upper).' AND (fm.m_dob_year IS NOT NULL)';
				}
			}
			else
				$where_clause	.=	" AND mcf.".$act_field." LIKE '%".db_escape_string($field_val)."%'";
		}

		$table	=	"galleries r LEFT JOIN ".get_table_prefix()."f_members fm ON (r.g_owner=fm.id OR (r.g_owner IS NULL AND fm.id=2)) RIGHT JOIN ".$GLOBALS['FORUM_DB']->get_table_prefix()."f_member_custom_fields as mcf ON fm.id=mcf.mf_member_id".$where_conds;

		if($art_type!='')
		{
			$where_clause		.=	" AND (g2.parent_id='".db_escape_string($art_type)."' AND g3.parent_id<>'root' OR g3.parent_id='".db_escape_string($art_type)."')";
			$table				.= " LEFT JOIN ".get_table_prefix()."galleries g2 ON g2.name=r.parent_id LEFT JOIN ".get_table_prefix()."galleries g3 ON g3.name=g2.parent_id";
		}

		// Only return content, not the gallery structure
		// FIXME: This is awful :(
		$where_clause .= " AND (r.name NOT IN ('writing', 'documentaries', 'short_films', 'film_genres', 'rock', 'metal', 'miscellaneous', 'miscfilm', 'film_types', 'photos', 'personal_photos', 'music', 'techno', 'training_educational', 'root', 'science_fiction', 'drama', 'feature_films', 'electronic', 'film', 'fineart', 'gospel', 'reggae', 'folk', 'adventure', 'pop', 'crime', 'handcrafted', 'country', 'photography', 'blues', 'dance', 'horror', 'action', 'punk', 'jazz', 'alternative', 'comedy', 'musicals', 'screenplay', 'screenplay_action', 'screenplay_children', 'screenplay_comedy', 'screenplay', 'screenplay_documentary', 'screenplay_drama', 'screenplay_family', 'screenplay_feature_film', 'screenplay_genre', 'screenplay_horror_sci-fi', 'screenplay_romance', 'screenplay_short_film', 'screenplay_type'))";

		// Look in the parent names too, so that searching for a category gets its
		// contents. First we grab the fields from a couple of levels above.
		// We have to make sure we don't conflict with the above addition to table
		if ($art_type=='')
			$table .= " LEFT JOIN ".get_table_prefix()."galleries g2 ON g2.name=r.parent_id LEFT JOIN ".get_table_prefix()."galleries g3 ON g3.name=g2.parent_id LEFT JOIN ".get_table_prefix()."galleries g4 ON g4.name=g3.parent_id";

		// Calculate and perform query
		// NOTE: We can get the fullname of the parents thanks to the above branch
		if ($art_type == '')
			$rows=get_search_rows('gallery','name',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table,array('r.fullname','r.description','g2.fullname','g3.fullname','g4.fullname'),$where_clause,$content_where,$remapped_orderer,'r.*',NULL,NULL,'name',true);
		else
			$rows=get_search_rows('gallery','name',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table,array('r.fullname','r.description','g2.fullname','g3.fullname'),$where_clause,$content_where,$remapped_orderer,'r.*',NULL,NULL,'name',true);

		$out=array();
		foreach ($rows as $i=>$row)
		{
			$out[$i]['data']=$row;
			unset($rows[$i]);
			if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
		}

		return $out;
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return tempcode	The output
	 */
	function render($row)
	{
		require_code('galleries');
		$tpl=show_gallery_box($row,'root',true,'_SEARCH',false,false,false);

		$pic			=	$row['rep_image'];
		$url			=	get_search_result_url(build_url(array('page'=>'galleries','type'=>'misc','root'=>NULL,'id'=>$row['name']),'_SEARCH'));

		$view_url	=	hyperlink($url,'View');

		$item			=	hyperlink($url,get_translated_text($row['fullname']));

		$item_type	=	$this->search_for_gallery_type($row['name']);

		$member	=	(is_null($row['g_owner']))?$GLOBALS['FORUM_DB']->query_value('f_members','id',array('m_username'=>'admin')):$row['g_owner'];

		$profile_url	=	get_search_result_url($GLOBALS['FORUM_DRIVER']->member_profile_link($member,true));

		$profile_url	=	hyperlink($profile_url,$GLOBALS['FORUM_DRIVER']->get_username($member));

		return array('Gallery image'=>$tpl,'Item name'=>$item,'Item type'=>$item_type,'Artist'=>$profile_url,'View'=>$view_url);
	}

	/**
	 * Function to find gallery type
	 *
	 * @param  ID_TEXT	Gallery
	 * @return ID_TEXT	Gallery type
	 */
	function search_for_gallery_type($cat='root')
	{
		$row	=	$GLOBALS['SITE_DB']->query_select('galleries',array('parent_id','fullname','name'),array('name'=>$cat));
		if(!array_key_exists(0,$row))	return;
		if(is_null($row[0]['parent_id']) || $row[0]['parent_id']=='')	return '';
		if($row[0]['parent_id']=='root')
		{
			$url			=	get_search_result_url(build_url(array('page'=>'galleries','type'=>'misc','root'=>NULL,'id'=>$row[0]['name']),'_SEARCH'));
			$view_url	=	hyperlink($url,get_translated_text($row[0]['fullname']));
			return $view_url;
		}
		else
			return $this->search_for_gallery_type($row[0]['parent_id']);
	}
}


