<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		catalogues
 */

class Hook_search_catalogue_entries
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		if (!module_installed('catalogues')) return NULL;

		global $SEARCH_CATALOGUE_ENTRIES_CATALOGUES;
		$SEARCH_CATALOGUE_ENTRIES_CATALOGUES=array();

		require_lang('catalogues');
		require_code('catalogues');

		$info=array();
		$info['lang']=do_lang_tempcode('CATALOGUE_ENTRIES');
		$info['default']=false;
		$info['category']='cc_id';
		$info['integer_category']=true;

		$extra_sort_fields=array();
		$catalogue_name=get_param('catalogue_name',NULL);
		if (!is_null($catalogue_name))
		{
			$rows=$GLOBALS['SITE_DB']->query_select('catalogue_fields',array('id','cf_name','cf_type','cf_default'),array('c_name'=>$catalogue_name,'cf_searchable'=>1,'cf_visible'=>1),'ORDER BY cf_order');
			foreach ($rows as $i=>$row)
			{
				require_code('hooks/modules/catalogue_fields/'.filter_naughty($row['cf_type']));
				$ob=object_factory('Hook_catalogue_field_'.filter_naughty($row['cf_type']));
				$temp=$ob->inputted_to_sql_for_search($row,$i);
				if (is_null($temp)) // Standard direct 'substring' search
				{
					$extra_sort_fields['f'.strval($i).'_actual_value']=get_translated_text($row['cf_name']);
				}
			}
		}
		$info['extra_sort_fields']=$extra_sort_fields;

		return $info;
	}

	/**
	 * Get a list of entries for the content covered by this search hook. In hierarchical list selection format.
	 *
	 * @param  string			The default selected item
	 * @return tempcode		Tree structure
	 */
	function get_tree($selected)
	{
		$catalogue_name=get_param('catalogue_name','');
		if ($catalogue_name=='')
		{
			@ob_end_clean();

			$tree=nice_get_catalogues();
			if ($tree->is_empty())
			{
				inform_exit(do_lang_tempcode('NO_ENTRIES'));
			}

			require_code('form_templates');
			$fields=form_input_list(do_lang_tempcode('NAME'),'','catalogue_name',$tree,NULL,true);
			$post_url=get_self_url(false,false,NULL,false,true);
			$submit_name=do_lang_tempcode('PROCEED');
			$hidden=build_keep_post_fields();

			$title=get_page_title('SEARCH');
			$tpl=do_template('FORM_SCREEN',array('_GUID'=>'a2812ac8056903811f444682d45ee448','TARGET'=>'_self','GET'=>true,'SKIP_VALIDATION'=>true,'HIDDEN'=>$hidden,'TITLE'=>$title,'TEXT'=>'','URL'=>$post_url,'FIELDS'=>$fields,'SUBMIT_NAME'=>$submit_name));
			$echo=globalise($tpl,NULL,'',true);
			$echo->evaluate_echo();
			exit();
		}

		$tree=nice_get_catalogue_category_tree($catalogue_name,intval($selected),false,true);
		return $tree;
	}

	/**
	 * Get a list of extra fields to ask for.
	 *
	 * @return array			A list of maps specifying extra fields
	 */
	function get_fields()
	{
		$fields=array();
		$catalogue_name=get_param('catalogue_name');
		$rows=$GLOBALS['SITE_DB']->query_select('catalogue_fields',array('id','cf_name','cf_type','cf_default'),array('c_name'=>$catalogue_name,'cf_searchable'=>1,'cf_visible'=>1),'ORDER BY cf_order');
		foreach ($rows as $row)
		{
			require_code('hooks/modules/catalogue_fields/'.filter_naughty($row['cf_type']));
			$ob=object_factory('Hook_catalogue_field_'.filter_naughty($row['cf_type']));
			$temp=$ob->get_search_inputter($row);
			if (is_null($temp))
			{
				$type='_TEXT';
				$special=get_param('option_'.strval($row['id']),'');
				$extra='';
				$display=get_translated_text($row['cf_name']);
				if (strpos($display,do_lang('RANGE_REQUIRED_TAG'))!==false) // FUDGEFUDGE: But leave
				{
					$display=str_replace(do_lang('RANGE_REQUIRED_TAG'),do_lang('RANGE_REQUIRED_SEARCH_DESCRIP'),$display);
					if (!is_guest())
					{
						$dob_year=intval($GLOBALS['FORUM_DRIVER']->get_member_row_field(get_member(),'m_dob_year'));
						if ($dob_year!=0) $special=number_format(intval(date('Y',servertime_to_usertime(time())))-$dob_year); // number_format'ing this is kind of funny actually
					}
					$extra='_ranged';
				}
				$fields[]=array('NAME'=>strval($row['id']).$extra,'DISPLAY'=>$display,'TYPE'=>$type,'SPECIAL'=>$special);
			} else $fields=array_merge($fields,$temp);
		}
		return $fields;
	}

	/**
	 * Standard modular run function for search results.
	 *
	 * @param  array			A list of words for the boolean search
	 * @param  boolean		Whether to only do a META (tags) search
	 * @param  ID_TEXT		Order direction
	 * @param  integer		Start position in total results
	 * @param  integer		Maximum results to return in total
	 * @param  boolean		Whether only to search titles (as opposed to both titles and content)
	 * @param  string			Where clause that selects the content according to the main search string (SQL query fragment) (blank: full-text search)
	 * @param  SHORT_TEXT	Username/Author to match for
	 * @param  ?MEMBER		Member-ID to match for (NULL: unknown)
	 * @param  TIME			Cutoff date
	 * @param  string			The sort type (gets remapped to a field in this function)
	 * @set    title add_date
	 * @param  integer		Limit to this number of results
	 * @param  string			What kind of boolean search to do
	 * @set    or and
	 * @param  string			Where constraints known by the main search code (SQL query fragment)
	 * @param  string			Comma-separated list of categories to search under
	 * @param  BINARY			Whether it is a boolean search
	 * @return array			List of maps (template, orderer)
	 */
	function run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$limit_to,$boolean_operator,$where_clause,$search_under,$boolean_search)
	{
		unset($limit_to);
		unset($boolean_operator);

		//if(!is_null(get_param('project_name',NULL)) && get_param('project_name')=='Project name')	$content_explode	=	array(get_param('project_name'));

		if (!module_installed('catalogues')) return array();

		$remapped_orderer='';
		switch ($sort)
		{
			case 'rating':
				$remapped_orderer='_rating:catalogues:id';
				break;

			case 'title':
				$remapped_orderer='b_cv_value';
				break;

			case 'add_date':
				$remapped_orderer='ce_add_date';
				break;

			case 'relevance':
			case 'rating':
				break;

			default:
				$remapped_orderer=$sort;
				break;
		}

		require_code('catalogues');
		require_lang('catalogues');

		// Calculate our where clause (search)
		$sq=build_search_submitter_clauses('ce_submitter',$author_id,$author);
		if (is_null($sq)) return array(); else $where_clause.=$sq;
		if (!is_null($cutoff))
		{
			$where_clause.=' AND ';
			$where_clause.='r.ce_add_date>'.strval($cutoff);
		}
		/*if (!$GLOBALS['FORUM_DRIVER']->is_super_admin(get_member()))
		{
			$where_clause.=' AND ';
			$where_clause.='z.category_name IS NOT NULL';
			$where_clause.=' AND ';
			$where_clause.='p.category_name IS NOT NULL';
		}*/
		if (!has_specific_permission(get_member(),'see_unvalidated'))
		{
			$where_clause.=' AND ';
			$where_clause.='ce_validated=1';
		}

		$g_or=_get_where_clause_groups(get_member());

		// Calculate and perform query
		$catalogue_name=get_param('catalogue_name','projects');	//NOTE: need to get catalogue name
		if($catalogue_name=='')	$catalogue_name	=	get_param('hook','');
		$ranges=array();
		if ($catalogue_name!='')
		{
			$extra_select='';

			$rows=$GLOBALS['SITE_DB']->query_select('catalogue_fields',array('id','cf_name','cf_type','cf_default'),array('c_name'=>$catalogue_name,'cf_searchable'=>1),'ORDER BY cf_order');
			$table='catalogue_entries r';
			$trans_fields=array('!');
			$nontrans_fields=array();
			$title_field=mixed();
			foreach ($rows as $i=>$row)
			{
				$field_indexes[get_translated_text($row['cf_name'])]=$i;
				require_code('hooks/modules/catalogue_fields/'.filter_naughty($row['cf_type']));
				$ob=object_factory('Hook_catalogue_field_'.filter_naughty($row['cf_type']));
				$temp=$ob->inputted_to_sql_for_search($row,$i);
				if (is_null($temp)) // Standard direct 'substring' search
				{
					list(,,$row_type)=$ob->get_field_value_row_bits($row['id']);
					switch ($row_type)
					{
						case 'long_trans':
							$trans_fields[]='f'.strval($i).'.cv_value';
							$table.=' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_efv_long_trans f'.strval($i).' ON (f'.strval($i).'.ce_id=r.id AND f'.strval($i).'.cf_id='.strval($row['id']).')';
							$search_field='t'.strval(count($trans_fields)-1).'.text_original';
							$extra_select.=',t'.strval(count($trans_fields)-1).'.text_original AS f'.strval($i).'_actual_value';
							break;
						case 'short_trans':
							$trans_fields[]='f'.strval($i).'.cv_value';
							$table.=' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_efv_short_trans f'.strval($i).' ON (f'.strval($i).'.ce_id=r.id AND f'.strval($i).'.cf_id='.strval($row['id']).')';
							$search_field='t'.strval(count($trans_fields)-1).'.text_original';
							$extra_select.=',t'.strval(count($trans_fields)-1).'.text_original AS f'.strval($i).'_actual_value';
							break;
						case 'long':
							$nontrans_fields[]='f'.strval($i).'.cv_value';
							$table.=' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_efv_long f'.strval($i).' ON (f'.strval($i).'.ce_id=r.id AND f'.strval($i).'.cf_id='.strval($row['id']).')';
							$search_field='f'.strval($i).'.cv_value';
							$extra_select.=',f'.strval($i).'.cv_value AS f'.strval($i).'_actual_value';
							break;
						case 'short':
							$nontrans_fields[]='f'.strval($i).'.cv_value';
							$table.=' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'catalogue_efv_short f'.strval($i).' ON (f'.strval($i).'.ce_id=r.id AND f'.strval($i).'.cf_id='.strval($row['id']).')';
							$search_field='f'.strval($i).'.cv_value';
							$extra_select.=',f'.strval($i).'.cv_value AS f'.strval($i).'_actual_value';
							break;
					}

					$param=get_param('option_'.strval($row['id']),'');
					if ($param!='')
					{
						$where_clause.=' AND ';
						if (substr($param,0,1)=='=')
						{
							$where_clause.=db_string_equal_to($search_field,substr($param,1));
						}
						elseif (strpos($param,'*')!==false)
						{
							$where_clause.=$search_field.' LIKE \''.db_encode_like('%'.str_replace('*','%',$param).'%').'\'';
						} else
						{
							$where_clause.=$search_field.' LIKE \''.db_encode_like('%'.$param.'%').'\'';
						}
					} else
					{
						$param=get_param('option_'.strval($row['id']).'_ranged','');
						if ($param!='') $ranges[$row['id']]=$param;
					}
				} else
				{
					$trans_fields=array_merge($trans_fields,$temp[0]);
					$non_trans_fields=array_merge($nontrans_fields,$temp[1]);
					$table.=$temp[2];
					$search_field=$temp[3];
					if ($temp[4]!='')
					{
						$where_clause.=' AND ';
						$where_clause.=$temp[4];
					}
				}
				if ($i==0) $title_field=$search_field;
			}

			$where_clause.=' AND ';
			$where_clause.=db_string_equal_to('r.c_name',$catalogue_name);

			if (is_null($title_field)) return array(); // No fields in catalogue -- very odd

			//Default field values
			$defaults	=	array('ocp_firstname'=>'First name','ocp_lastname'=>'Last name','ocp_city'=>'City','ocp_state'=>'State');

			$matching_fields['ocp_firstname']	=	get_param('first_name',NULL);
			$matching_fields['ocp_lastname']	=	get_param('last_name',NULL);
			$matching_fields['ocp_city']	=	get_param('city',NULL);
			$matching_fields['ocp_state']	=	get_param('state',NULL);
			$where_conds	=	NULL;

			if(!is_null(get_param('project_name',NULL)) && get_param('project_name')!='Project name')
			{
				$where_clause	.=	" AND f0.cv_value LIKE '".db_encode_like('%'.get_param('project_name').'%')."'";
			}

			if(get_param('project_type','')!='')
			{
				$project_type	=	get_param('project_type');
				$where_clause	.=	"AND f".$field_indexes['Project type'].".cv_value ='".db_escape_string($project_type)."'";
			}

			if(get_param('project_status','')!='')
			{
				$project_status =	get_param('project_status');
				$where_clause	.=	"AND f".$field_indexes['Project status'].".cv_value ='".db_escape_string($project_status)."'";
			}

			foreach($matching_fields as $field_name=>$field_val)
			{
				if (is_null($field_val)) continue;

				if($defaults[$field_name]==$field_val) continue;
				$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".$field_name."'";

				$row=$GLOBALS['SITE_DB']->query($sql);
				if(!array_key_exists(0,$row)) return;

				$fields[]['field_'.$row[0]['id']]=$field_val;
				$act_field	=	'field_'.$row[0]['id'];

				$where_conds	.=	" AND t4.".$act_field." LIKE '%".db_escape_string($field_val)."%'";
			}

			$table	.=	" LEFT JOIN ".$GLOBALS['FORUM_DB']->get_table_prefix()."f_members t3 ON r.ce_submitter=t3.id LEFT JOIN ".$GLOBALS['FORUM_DB']->get_table_prefix()."f_member_custom_fields as t4 ON t3.id=t4.mf_member_id".$where_conds;
			if ($g_or=='')
			{
				$rows=get_search_rows('catalogue_entry','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table,$trans_fields,$where_clause,$content_where,str_replace('b_cv_value',$title_field,$remapped_orderer),'*,r.id AS id,r.cc_id AS r_cc_id,'.$title_field.' AS b_cv_value'.$extra_select,$nontrans_fields);
			} else
			{
				$rows=get_search_rows('catalogue_entry','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$table/*.' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'group_category_access z ON ('.db_string_equal_to('z.module_the_name','catalogues_category').' AND z.category_name=r.cc_id AND '.str_replace('group_id','z.group_id',$g_or).') LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'group_category_access p ON ('.db_string_equal_to('p.module_the_name','catalogues_catalogue').' AND p.category_name=r.c_name AND '.str_replace('group_id','p.group_id',$g_or).')'*/,$trans_fields,$where_clause,$content_where,str_replace('b_cv_value',$title_field,$remapped_orderer),'*,r.id AS id,r.cc_id AS r_cc_id,'.$title_field.' AS b_cv_value'.$extra_select,$nontrans_fields);
			}
		} else
		{
			if ($g_or=='')
			{
				$rows=get_search_rows('catalogue_entry','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,'(catalogue_fields f,'.get_table_prefix().'catalogue_entries r) LEFT JOIN '.get_table_prefix().'catalogue_efv_short_trans a ON (r.id=a.ce_id AND f.id=a.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_long_trans b ON (r.id=b.ce_id AND f.id=b.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_short c ON (r.id=c.ce_id AND f.id=c.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_long d ON (r.id=d.ce_id AND f.id=d.cf_id)',array('a.cv_value','b.cv_value'),$where_clause,$content_where,str_replace('b_cv_value','b.cv_value',$remapped_orderer),'*,r.id AS id,r.cc_id AS r_cc_id,b.cv_value AS b_cv_value',array('c.cv_value','d.cv_value'));
			} else
			{
				$rows=get_search_rows('catalogue_entry','id',$content_explode,$only_search_meta,$direction,$max,$start,$only_titles,'(catalogue_fields f,'.get_table_prefix().'catalogue_entries r) LEFT JOIN '.get_table_prefix().'catalogue_efv_short_trans a ON (r.id=a.ce_id AND f.id=a.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_long_trans b ON (r.id=b.ce_id AND f.id=b.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_short c ON (r.id=c.ce_id AND f.id=c.cf_id) LEFT JOIN '.get_table_prefix().'catalogue_efv_long d ON (r.id=d.ce_id AND f.id=d.cf_id)'/*.' LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'group_category_access z ON ('.db_string_equal_to('z.module_the_name','catalogues_category').' AND z.category_name=r.cc_id AND '.str_replace('group_id','z.group_id',$g_or).') LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'group_category_access p ON ('.db_string_equal_to('p.module_the_name','catalogues_catalogue').' AND p.category_name=r.c_name AND '.str_replace('group_id','p.group_id',$g_or).')',array('a.cv_value','b.cv_value')*/,$where_clause,$content_where,str_replace('b_cv_value','b.cv_value',$remapped_orderer),'*,r.id AS id,r.cc_id AS r_cc_id,b.cv_value AS b_cv_value',array('c.cv_value','d.cv_value'));
			}
		}

		$out=array();
		if (count($rows)==0) return array();

		global $SEARCH_CATALOGUE_ENTRIES_CATALOGUES;
		$_catalogues=$GLOBALS['SITE_DB']->query_select('catalogues',array('*'));
		foreach ($_catalogues as $catalogue)
		{
			$SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue['c_name']]=$catalogue;
		}
		if (count($ranges)!=0) // Unfortunately we have to actually load these up to tell if we can use
		{
			foreach ($rows as $i=>$row)
			{
				$catalogue_name=$row['c_name'];
				$tpl_set=$catalogue_name;
				$display=get_catalogue_entry_map($row,$SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name],'PAGE',$tpl_set,-1);
				foreach ($ranges as $range_id=>$range_key)
				{
					$bits=explode('-',$display['_FIELD_'.strval($range_id)]);
					if (count($bits)==2)
					{
						if ((intval($bits[0])>=intval($range_key)) || (intval($bits[1])<=intval($range_key)))
						{
							$out[$i]['restricted']=true;
							continue 2;
						}
					}
				}

				//$out[$i]['template']=do_template('CATALOGUE_'.$tpl_set.'_ENTRY_EMBED',$display,NULL,false,'CATALOGUE_DEFAULT_ENTRY_EMBED');//put_in_table(hyperlink($url,do_lang('_HERE')),'internal','middle','WIDE',1,do_lang('CATALOGUE_ENTRY').' ('.do_lang('IN',get_translated_text($catalogue['c_title'])).')');
				if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
			}
		} else
		{
			foreach ($rows as $i=>$row)
			{
				$out[$i]['data']=$row;
				unset($rows[$i]);
				if (($remapped_orderer!='') && (array_key_exists($remapped_orderer,$row))) $out[$i]['orderer']=$row[$remapped_orderer]; elseif (substr($remapped_orderer,0,7)=='_rating') $out[$i]['orderer']=$row['compound_rating'];
			}
		}

		return $out;
	}

	/**
	 * Standard modular run function for rendering a search result.
	 *
	 * @param  array		The data row stored when we retrieved the result
	 * @return tempcode	The output
	 */
	function render($row)
	{
		require_code('ocf_members');
		global $SEARCH_CATALOGUE_ENTRIES_CATALOGUES;

		$catalogue_name=$row['c_name'];
		if (!array_key_exists($catalogue_name,$SEARCH_CATALOGUE_ENTRIES_CATALOGUES)) return new ocp_tempcode();
		if (($SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name]['c_display_type']==0) || (get_param_integer('specific',0)==0))
		{
			$tpl_set=$catalogue_name;
			$display=get_catalogue_entry_map($row,$SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name],'SEARCH',$tpl_set,-1);
			foreach($display['FIELDS_1D'] as $value)
			{
				$field	=	get_translated_text($value['cf_name']);
				if($field=='Project title' || $field=='Project type')
				{
					$field_val[$field]	=	array_key_exists('effective_value_pure',$value)?$value['effective_value_pure']:$value['effective_value'];
				}
			}

			if(!is_null($row['ce_submitter']))
			{
				$cpf_data	=	ocf_get_custom_field_mappings($row['ce_submitter']);
				$sql="SELECT t2.id,t1.text_original FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND (t1.text_original='ocp_state' OR t1.text_original='ocp_city')";

				$res			=	$GLOBALS['SITE_DB']->query($sql);
				$location	=	array();
				foreach($res as $locations)
				{
					$field_name	=	'field_'.$locations['id'];
					if($cpf_data[$field_name]!='')	$location[]	=	$cpf_data[$field_name];
				}

				$field_val['Location']	=	array_key_exists(0,$location)?implode(", ",$location):'-';
				$submitter	=	get_search_result_url($GLOBALS['FORUM_DRIVER']->member_profile_link($row['ce_submitter'],true));
				$field_val['Submitter']	=	hyperlink($submitter,$GLOBALS['FORUM_DRIVER']->get_username($row['ce_submitter']));
			}

			$url	=	build_url(array('page'=>'catalogues','type'=>'entry','id'=>$row['id']),'_SEARCH');
			$field_val['View']	=	hyperlink(get_search_result_url($url),'View');
			if(!array_key_exists('Project title',$field_val))	return;
			$field_val['Project title']	=	hyperlink(get_search_result_url($url),$field_val['Project title']);
			return $field_val;
		}
	}

}


