<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

function init__database_search($code)
{
	$GLOBALS['TOTAL_RESULTS']=0;
	$code=str_replace("ksort(\$ultimate_field_map);","",$code);
	$code=str_replace("ksort(\$r);","",$code);
	return $code;
}

/**
* Function to get defaults data of cpfs as option list
*
* @param		ID_TEXT		Cpf name
* @param		ID_TEXT?		Selected option/NULL
* @return 	tempcode		Options list
*/
function get_cpf_default_value_list($cpf_name,$selected=NULL)
{
	$list	=	new ocp_tempcode();

	$sql="SELECT t2.cf_default,t2.cf_type FROM ".$GLOBALS['SITE_DB']->get_table_prefix()."f_custom_fields t2,".$GLOBALS['SITE_DB']->get_table_prefix()."translate t1 WHERE t1.id=t2.cf_name AND t1.text_original='".db_escape_string($cpf_name)."'";

	$field=$GLOBALS['SITE_DB']->query($sql);
	if(!array_key_exists(0,$field)) return $list;

	$default=$field[0]['cf_default'];
	if (substr($field[0]['cf_type'],-4)=='list')
	{
		$_default=explode('|',$default);
		foreach($_default as $option)
		{
			$list->attach(form_input_list_entry($option,$option==$selected,$option));
		}
	}

	return $list;
}

/**
* Function to return search result link
*
* @param		mixed			Link
* @return 	tempcode		Result link
*/
function get_search_result_url($url)
{
	return build_url(array('page'=>'search','type'=>'result_link','redirect'=>base64_encode(is_object($url)?$url->evaluate():$url)),'_SEARCH');
}

/**
* Function to return search result for all hooks
*
* @param  ID_TEXT		Codename for what's being searched (blank: mixed search)
* @param  string		Author name
* @param  ?AUTO_LINK	Author ID (NULL: none given)
* @param  integer		Days to search
* @param  ID_TEXT		Sort key
* @param  ID_TEXT		Sort direction
* @set    ASC DESC
* @param  boolean		Whether to only search titles
* @param  string		Comma-separated list of categories to search under
* @param	 string		Content to search (if not passed, value will take from get parameter)
* @return array		A triple: The results, results browser, the number of results
*/
function get_results($id,$author,$author_id,$days,$sort,$direction,$only_titles,$search_under,$hook,$content='')
{
	$title=get_page_title('RESULTS');

	cache_module_installed_status();

	$cutoff=($days==-1)?NULL:(time()-$days*24*60*60);

	// What we're searching for
	$content=get_param('content',$content);

	// Search keyword highlighting in any loaded Comcode
	global $SEARCH__CONTENT_BITS;
	$_content_bits=explode(' ',str_replace('"','',str_replace('+','',str_replace('-','',$content))));
	$SEARCH__CONTENT_BITS=array();
	foreach ($_content_bits as $content_bit)
	{
		if (trim($content_bit)!='') $SEARCH__CONTENT_BITS[]=$content_bit;
	}

	$start=get_param_integer('start',0);
	$max=get_param_integer('max',10);  // Also see get_search_rows

	$save_title=post_param('save_title','');
	if ((!is_guest()) && ($save_title!='') && ($start==0))
	{
		$GLOBALS['SITE_DB']->query_insert('searches_saved',array(
			's_title'=>$save_title,
			's_member_id'=>get_member(),
			's_time'=>time(),
			's_primary'=>$content,
			's_auxillary'=>serialize(array_merge($_POST,$_GET)),
		));
	}

	$boolean_operator=get_param('conjunctive_operator','OR');
	list($content_where,$content_explode)=build_content_where($content,get_param_integer('boolean_search',0)==1,$boolean_operator);

	// Search under all hooks we've asked to search under
	$results=array();

	require_code('hooks/modules/search/'.filter_naughty_harsh($hook));
	$object=object_factory('Hook_search_'.filter_naughty_harsh($hook),true);
	if (is_null($object)) return array(array(),new ocp_tempcode(),new ocp_tempcode());
	$info=$object->info();
	if (is_null($info)) return array(array(),new ocp_tempcode(),new ocp_tempcode());

	// Category filter
	if (($search_under!='!') && ($search_under!='-1') && (array_key_exists('category',$info)))
	{
		$cats=explode(',',$search_under);
		$where_clause='(';
		foreach ($cats as $cat)
		{
			if (trim($cat)=='') continue;

			if ($where_clause!='(') $where_clause.=' OR ';
			if ($info['integer_category'])
			{
				$where_clause.='r.'.$info['category'].'='.strval((integer)$cat);
			} else
			{
				$where_clause.=db_string_equal_to('r.'.$info['category'],$cat);
			}
		}
		$where_clause.=')';
	} else $where_clause='';

	$only_search_meta=get_param_integer('only_search_meta',0)==1;
	$max=get_param_integer('max',20);
	$start=get_param_integer('start',0);
	$hook_results=$object->run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$id,$boolean_operator,$where_clause,$search_under,get_param_integer('boolean_search',0));

	if (is_null($hook_results)) continue;
	foreach ($hook_results as $i=>$result)
	{
		$result['object']=$object;
		$hook_results[$i]=$result;
	}
	$results=sort_search_results($hook_results,$results,$direction);

	// Now glue our templates together
	$out=new ocp_tempcode();
	$i=0;
	global $CATALOGUE_ENTRIES_BUILDUP;
	$CATALOGUE_ENTRIES_BUILDUP=array();
	$tabular_results=array();

	foreach ($results as $result)
	{
		if (array_key_exists('restricted',$result)) continue; // This has been blanked out due to insufficient access permissions or some other reason

		if ($i>=$start+$max) break;

		if ($i>=$start)
		{
			if (array_key_exists('template',$result))
			{
				$rendered_result=$result['template'];
			} else
			{
				if (($id!='') && (method_exists($result['object'],'render_tabular')))
				{
					$rendered_result=$result['object']->render_tabular($result['data']);
				} else
				{
					$rendered_result=$result['object']->render($result['data']);
				}
			}

			if (!is_null($rendered_result))
			{
				if (is_array($rendered_result))
				{
					$class=get_class($result['object']);
					if (!array_key_exists($class,$tabular_results)) $tabular_results[$class]=array();
					$tabular_results[$class][]=$rendered_result;
				} else
				{
					$out->attach(do_template('SEARCH_RESULT',array('_GUID'=>'47da093f9ace87819e246f0cec1402a9','CONTENT'=>$rendered_result)));
				}
			}
		}
		$i++;
	}
	foreach ($tabular_results as $tabular_type=>$types_results)
	{
		// Normalisation process
		$ultimate_field_map=array();
		foreach ($types_results as $r)
			$ultimate_field_map+=$r;
		//ksort($ultimate_field_map);
		$ultimate_field_map=array_keys($ultimate_field_map);
		foreach ($types_results as $i=>$r)
		{
			$r2d2=array();
			foreach ($ultimate_field_map as $key)
			{
				if (!array_key_exists($key,$r)) $r[$key]='';
				$r2d2[$key]=$r[$key];
			}
			//ksort($r);
			$r=$r2d2;
			$types_results[$i]=array('R'=>$r);
		}
		// Output
		$out->attach(do_template('SEARCH_RESULT_TABLE',array('HEADERS'=>$ultimate_field_map,'ROWS'=>$types_results)));
	}

	if (count($CATALOGUE_ENTRIES_BUILDUP)!=0)
	{
		global $SEARCH_CATALOGUE_ENTRIES_CATALOGUES;
		foreach ($CATALOGUE_ENTRIES_BUILDUP as $catalogue_name=>$catalogue_entries)
		{
			$tpl_set=$catalogue_name;
			$buildup=get_catalogue_category_entry_buildup(NULL,$catalogue_name,$SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name],'SEARCH',$tpl_set,NULL,NULL,NULL,-1,NULL,false,$catalogue_entries);
			$out->attach(do_template('SEARCH_RESULT_CATALOGUE_ENTRIES',array('_GUID'=>'dd0045ac291275b2d822d40b28182a28','BUILDUP'=>$buildup[0],'NAME'=>$catalogue_name,'TITLE'=>get_translated_text($SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name]['c_title']))));
		}
	}

	$GLOBALS['META_DATA']+=array(
		'opensearch_totalresults'=>strval($i),
		'opensearch_startindex'=>strval($start),
		'opensearch_itemsperpage'=>strval($max),
	);

	$SEARCH__CONTENT_BITS=NULL;

	//$out=build_search_results_interface($results,$start,$max,$direction);
	if ($out->is_empty()) return array(new ocp_tempcode(),new ocp_tempcode(),0);

	require_code('templates_results_browser');
	$results_browser=results_browser(do_lang_tempcode('RESULTS'),NULL,$start,'start',$max,'max',count($results),NULL,'results',true,true);

	if ($start==0)
	{
		$GLOBALS['SITE_DB']->query_insert('searches_logged',array(
			's_member_id'=>get_member(),
			's_time'=>time(),
			's_primary'=>$content,
			's_auxillary'=>serialize(array_merge($_POST,$_GET)),
			's_num_results'=>count($results),
		));
	}

	return array($out,$results_browser,count($tabular_results));
}

/**
* Function which call main search function.
*
* @param		mixed		Link
* @return 	array		Result
*/
function search_data($hook)
{
	$self_url		=	get_self_url();
	$url_params		=	parse_url($self_url->evaluate());
	if (!array_key_exists('query',$url_params)) return;
	if(!strstr($url_params['query'],'content'))	return;

	//Search results section
	$author=get_param('author','');
	$author_id=($author!='')?$GLOBALS['FORUM_DRIVER']->get_member_from_username($author):NULL;
	$days=get_param_integer('days',-1);
	$sort=get_param('sort','relevance');
	$direction=get_param('direction','DESC');
	if (!in_array($direction,array('ASC','DESC'))) log_hack_attack_and_exit('ORDERBY_HACK');
	$only_titles=get_param_integer('only_titles',0)==1;
	$search_under=get_param('search_under','!',true);
	$boolean_operator=	get_param('conjunctive_operator','OR');
	$id=get_param('id',$hook);
	list($results['out'],$results['results_browser'],$results['num_results'])	=	get_results($id,$author,$author_id,$days,$sort,$direction,$only_titles,$search_under,$hook);

	return $results;
}

/**
* Function to find search results for each tab
*
* @return 	array		Result array
*/
function get_search_results_of_tabs()
{
	$_hooks=find_all_hooks('systems','tab_contents');
	$i=0;
	foreach (array_keys($_hooks) as $hook)
	{
		require_code('hooks/systems/tab_contents/'.filter_naughty_harsh($hook));
		$object				=	object_factory('Hook_'.filter_naughty_harsh($hook),true);
		if(!method_exists($object,'get_search_hook') || is_null($object->get_search_hook()))	continue;
		$search_hook		=	$object->get_search_hook();
		$results[$hook]	=	search_data($search_hook);

		$i++;
	}
	uasort($results,'find_max_result_hook');
	return $results;
}

/**
* User defined function for sorting all tab's results array by result count
* @param		array		Data item
* @param		array		Data item
* @return 	number	Compare status
*/
function find_max_result_hook($a,$b)
{
	return (intval($a['num_results'])>intval($b['num_results']))? -1 : 1;
}



