<?php /*

 ocPortal
 Copyright (c) ocProducts, 2004-2009

 See text/en/licence.txt for full licencing information.

*/

/**
 * @license		http://opensource.org/licenses/cpal_1.0 Common Public Attribution License
 * @copyright	ocProducts Ltd
 * @package		core_search
 */

class Module_search
{

	/**
	 * Standard modular info function.
	 *
	 * @return ?array	Map of module info (NULL: module is disabled).
	 */
	function info()
	{
		$info=array();
		$info['author']='Chris Graham';
		$info['organisation']='ocProducts';
		$info['hacked_by']=NULL;
		$info['hack_version']=NULL;
		$info['version']=3;
		$info['update_require_upgrade']=0;
		$info['locked']=true;
		return $info;
	}

	/**
	 * Standard modular uninstall function.
	 */
	function uninstall()
	{
		$GLOBALS['SITE_DB']->drop_if_exists('searches_saved');
		$GLOBALS['SITE_DB']->drop_if_exists('searches_logged');
	}

	/**
	 * Standard modular install function.
	 *
	 * @param  ?integer	What version we're upgrading from (NULL: new install)
	 * @param  ?integer	What hack version we're upgrading from (NULL: new-install/not-upgrading-from-a-hacked-version)
	 */
	function install($upgrade_from=NULL,$upgrade_from_hack=NULL)
	{
		$GLOBALS['SITE_DB']->create_table('searches_saved',array(
			'id'=>'*AUTO',
			's_title'=>'SHORT_TEXT',
			's_member_id'=>'USER',
			's_time'=>'TIME',
			's_primary'=>'SHORT_TEXT',
			's_auxillary'=>'LONG_TEXT',
		));

		$GLOBALS['SITE_DB']->create_table('searches_logged',array(
			'id'=>'*AUTO',
			's_member_id'=>'USER',
			's_time'=>'TIME',
			's_primary'=>'SHORT_TEXT',
			's_auxillary'=>'LONG_TEXT',
			's_num_results'=>'INTEGER',
		));

		$GLOBALS['SITE_DB']->create_index('searches_logged','past_search',array('s_primary'));
	}

	/**
	 * Standard modular entry-point finder function.
	 *
	 * @return ?array	A map of entry points (type-code=>language-code) (NULL: disabled).
	 */
	function get_entry_points()
	{
		return array('misc'=>'SEARCH_TITLE','my'=>'SAVED_SEARCHES');
	}

	/**
	 * Standard modular page-link finder function (does not return the main entry-points that are not inside the tree).
	 *
	 * @param  ?integer  The number of tree levels to computer (NULL: no limit)
	 * @param  boolean	Whether to not return stuff that does not support permissions (unless it is underneath something that does).
	 * @param  ?string	Position to start at in the tree. Does not need to be respected. (NULL: from root)
	 * @param  boolean	Whether to avoid returning categories.
	 * @return ?array	 	A tuple: 1) full tree structure [made up of (pagelink, permission-module, permissions-id, title, children, ?entry point for the children, ?children permission module, ?whether there are children) OR a list of maps from a get_* function] 2) permissions-page 3) optional base entry-point for the tree 4) optional permission-module 5) optional permissions-id (NULL: disabled).
	 */
	function get_page_links($max_depth=NULL,$require_permission_support=false,$start_at=NULL,$dont_care_about_categories=false)
	{
		$permission_page=NULL;

		if (!is_null($start_at))
		{
			$matches=array();
			if (preg_match('#[^:]*:search:type=misc:id=(.*)#',$start_at,$matches)!=0) // Could only be catalogues
			{
				$kids=array();
				$rows=$dont_care_about_categories?array():$GLOBALS['SITE_DB']->query_select('catalogues c LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'translate t ON '.db_string_equal_to('language',user_lang()).' AND c.c_title=t.id',array('c.c_title','c_name','text_original'));
				foreach ($rows as $row)
				{
					if (is_null($row['text_original'])) $row['text_original']=get_translated_text($row['c_title']);

					$kids[]=array('_SELF:_SELF:type=misc:id=catalogue_entries:catalogue_name='.$row['c_name'],NULL,NULL,$row['text_original'],array());
				}

				return array($kids,$permission_page);
			}
		}

		$tree=array();
		if ((!$require_permission_support) && ($max_depth>0))
		{
			$_hooks=find_all_hooks('modules','search');
			foreach (array_keys($_hooks) as $hook)
			{
				require_code('hooks/modules/search/'.filter_naughty_harsh($hook));
				$object=object_factory('Hook_search_'.filter_naughty_harsh($hook),true);
				if (is_null($object)) continue;
				$info=$object->info();
				if (is_null($info)) continue;

				if (($hook=='catalogue_entries') || (array_key_exists('special_on',$info)) || (array_key_exists('special_off',$info)) || (method_exists($object,'get_tree')) || (method_exists($object,'ajax_tree')))
				{
					$kids=array();
					if (($hook=='catalogue_entries') && ($max_depth>1))
					{
						$rows=$dont_care_about_categories?array():$GLOBALS['SITE_DB']->query_select('catalogues c LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'translate t ON '.db_string_equal_to('language',user_lang()).' AND c.c_title=t.id',array('c.c_title','c_name','text_original'));
						foreach ($rows as $row)
						{
							if (!has_category_access(get_member(),'catalogues_catalogue',$row['c_name'])) continue;

							if (is_null($row['text_original'])) $row['text_original']=get_translated_text($row['c_title']);

							$kids[]=array('_SELF:_SELF:type=misc:id='.$hook.':catalogue_name='.$row['c_name'],NULL,NULL,$row['text_original'],array());
						}
					}
					$tree[]=array('_SELF:_SELF:type=misc:id='.$hook,NULL,NULL,$info['lang'],$kids,'','',$hook=='catalogue_entries');
				}
			}
		}
		return array($tree,$permission_page);
	}

	/**
	 * Standard modular new-style deep page-link finder function (does not return the main entry-points).
	 *
	 * @param  string  	Callback function to send discovered page-links to.
	 * @param  MEMBER		The member we are finding stuff for (we only find what the member can view).
	 * @param  integer	Code for how deep we are tunnelling down, in terms of whether we are getting entries as well as categories.
	 * @param  string		Stub used to create page-links. This is passed in because we don't want to assume a zone or page name within this function.
	 * @param  ?string	Where we're looking under (NULL: root of tree). We typically will NOT show a root node as there's often already an entry-point representing it.
	 * @param  integer	Our recursion depth (used to calculate importance of page-link, used for instance by Google sitemap). Deeper is typically less important.
	 * @param  ?array		Non-standard for API [extra parameter tacked on] (NULL: yet unknown). Contents of database table for performance.
	 * @param  ?array		Non-standard for API [extra parameter tacked on] (NULL: yet unknown). Contents of database table for performance.
	 */
	function get_sitemap_pagelinks($callback,$member_id,$depth,$pagelink_stub,$parent_pagelink=NULL,$recurse_level=0,$category_data=NULL,$entry_data=NULL)
	{
		$parent_pagelink=$pagelink_stub.':misc'; // This is the entry-point we're under

		$_hooks=find_all_hooks('modules','search');
		foreach (array_keys($_hooks) as $hook)
		{
			require_code('hooks/modules/search/'.filter_naughty_harsh($hook));
			$object=object_factory('Hook_search_'.filter_naughty_harsh($hook),true);
			if (is_null($object)) continue;
			$info=$object->info();
			if (is_null($info)) continue;

			if (($hook=='catalogue_entries') || (array_key_exists('special_on',$info)) || (array_key_exists('special_off',$info)) || (method_exists($object,'get_tree')) || (method_exists($object,'ajax_tree')))
			{
				$kids=array();
				if ($hook=='catalogue_entries')
				{
					$rows=$GLOBALS['SITE_DB']->query_select('catalogues c LEFT JOIN '.$GLOBALS['SITE_DB']->get_table_prefix().'translate t ON '.db_string_equal_to('language',user_lang()).' AND c.c_title=t.id',array('c.c_title','c_name','text_original'));
					foreach ($rows as $row)
					{
						if (!has_category_access($member_id,'catalogues_catalogue',$row['c_name'])) continue;

						if (is_null($row['text_original'])) $row['text_original']=get_translated_text($row['c_title']);

						$pagelink=$pagelink_stub.'misc:id='.$hook.':catalogue_name='.$row['c_name'];
						call_user_func_array($callback,array($pagelink,$pagelink_stub.'misc:id='.$hook,NULL,NULL,0.2,$row['text_original'])); // Callback
					}
				}

				$pagelink=$pagelink_stub.'misc:id='.$hook;
				call_user_func_array($callback,array($pagelink,$parent_pagelink,NULL,NULL,0.2,$info['lang'])); // Callback
			}
		}
	}

	/**
	 * Standard modular run function.
	 *
	 * @return tempcode	The result of execution.
	 */
	function run()
	{
		require_lang('search');
		require_css('search');
		require_code('database_search');

		if (function_exists('set_time_limit')) @set_time_limit(0);

		$type=get_param('type','misc');
		if (($type=='misc') || ($type=='results')) return $this->form();
		//if ($type=='results') return $this->results();
		if ($type=='my') return $this->my();
		if ($type=='_delete') return $this->_delete();
		if ($type=='result_link')	return	$this->result_link_redirect();
		if	($type=='guest_join') return $this->join_for_access();

		return new ocp_tempcode();
	}

	/**
	 * The UI to choose a saved search.
	 *
	 * @return tempcode		The UI
	 */
	function my()
	{
		if (is_guest()) access_denied('NOT_AS_GUEST');

		require_code('templates_results_table');

		$title=get_page_title('SAVED_SEARCHES');

		$start=get_param_integer('start',0);
		$max=get_param_integer('max',50);
		$sortables=array('s_time'=>do_lang_tempcode('DATE_TIME'),'s_title'=>do_lang_tempcode('TITLE'));
		list($sortable,$sort_order)=explode(' ',get_param('sort','s_time DESC'));
		if ((($sort_order!='ASC') && ($sort_order!='DESC')) || (!array_key_exists($sortable,$sortables)))
			log_hack_attack_and_exit('ORDERBY_HACK');
		$fields_title=results_field_title(array(do_lang_tempcode('TITLE'),do_lang_tempcode('DATE_TIME'),do_lang_tempcode('DELETE'),do_lang_tempcode('RUN_SEARCH')),$sortables,'sort');
		$max_rows=$GLOBALS['SITE_DB']->query_value('searches_saved','COUNT(*)',array('s_member_id'=>get_member()));
		$rows=$GLOBALS['SITE_DB']->query_select('searches_saved',array('*'),array('s_member_id'=>get_member()),'ORDER BY '.$sortable.' '.$sort_order,$max,$start);
		$fields=new ocp_tempcode();
		foreach ($rows as $row)
		{
			$post_url=build_url(array('page'=>'_SELF','type'=>'_delete'),'_SELF');
			$deletion_button=do_template('SEARCH_SAVED_DELETION_BUTTON',array('_GUID'=>'ac55dd5cd40e2ee09f5ac48110ee7215','URL'=>$post_url,'ID'=>strval($row['id'])));

			$post_url=build_url(array('page'=>'_SELF','type'=>'results'),'_SELF',NULL,false,true);
			$hidden=new ocp_tempcode();
			$post=unserialize($row['s_auxillary']);
			foreach ($post as $key=>$val)
			{
				if ($key!='save_title')
				{
					if (get_magic_quotes_gpc()) $val=stripslashes($val);
					$hidden->attach(form_input_hidden($key,$val));
				}
			}
			$run_button=do_template('SEARCH_SAVED_RUN_BUTTON',array('_GUID'=>'8ce6e09b76cfd6a1db59f1ab46376feb','URL'=>$post_url,'HIDDEN'=>$hidden));

			$fields->attach(results_entry(array($row['s_title'],get_timezoned_date($row['s_time']),$deletion_button,$run_button),true));
		}
		$searches=results_table(do_lang_tempcode('SAVED_SEARCHES'),$start,'start',$max,'max',$max_rows,$fields_title,$fields,$sortables,$sortable,$sort_order,'sort',new ocp_tempcode());

		$post_url=build_url(array('page'=>'_SELF','type'=>'my'),'_SELF');

		return do_template('SEARCH_SAVED_SCREEN',array('_GUID'=>'f9a7116b8525eb223bde50dfb991f39f','TITLE'=>$title,'SEARCHES'=>$searches,'URL'=>$post_url));
	}

	/**
	 * The actualiser to delete a saved search.
	 *
	 * @return tempcode		The UI
	 */
	function _delete()
	{
		$title=get_page_title('DELETE_SAVED_SEARCH');

		if (is_guest()) access_denied('NOT_AS_GUEST');

		$GLOBALS['SITE_DB']->query_delete('searches_saved',array('id'=>post_param_integer('id'),'s_member_id'=>get_member()),'',1);

		$url=build_url(array('page'=>'_SELF','type'=>'my'),'_SELF');
		return redirect_screen($title,$url,do_lang_tempcode('SUCCESS'));
	}

	/**
	 * The UI to do a search.
	 *
	 * @return tempcode		The UI
	 */
	function form()
	{
		$id=get_param('id','');

		$search_under=get_param('search_under','!',true);

		if ($id!='') // Specific screen, prepare
		{	
			require_code('hooks/modules/search/'.filter_naughty_harsh($id),true);
			$object=object_factory('Hook_search_'.filter_naughty_harsh($id));
			$info=$object->info();

			$title=get_page_title('_SEARCH_TITLE',true,array($info['lang']));
			if(get_param('keep_no_breadcrumbs',0)==0)
			{
				breadcrumb_set_parents(array(array('_SELF:_SELF',do_lang_tempcode('CHOOSE'))));
				breadcrumb_set_self($info['lang']);
			}

			if ((!is_null($info)) && (method_exists($object,'get_tree'))) $object->get_tree($search_under);
		} else
		{
			$title=get_page_title('SEARCH_TITLE');
		}

		require_code('templates_internalise_screen');
		$test_tpl=internalise_own_screen($title);
		if (is_object($test_tpl)) return $test_tpl;

		require_javascript('javascript_ajax');
		require_javascript('javascript_ajax_people_lists');

		$content=get_param('content',NULL,true);

		$user_label=do_lang_tempcode('SEARCH_USER');
		$days_label=do_lang_tempcode('SUBMITTED_WITHIN');

		$extra_sort_fields=array();

		if ($id!='') // Specific screen
		{
			$url_map=array('page'=>'_SELF','type'=>'results','id'=>$id,'specific'=>1);
			$catalogue_name=get_param('catalogue_name','');
			if ($catalogue_name!='') $url_map['catalogue_name']=$catalogue_name;
			foreach (array_keys($_GET) as $key) // So architecturally, we can handle simultaneous searching so long as the hooks custom params are symettrical (e.g. images AND videos AND galleries)
			{
				if ((substr($key,0,7)=='search_') && ($key!='search_under'))
					$url_map[$key]=get_param($key);
			}
			$url=build_url($url_map,'_SELF',NULL,false,true);

			require_code('hooks/modules/search/'.filter_naughty_harsh($id),true);
			$object=object_factory('Hook_search_'.filter_naughty_harsh($id));
			$info=$object->info();
			if (is_null($info)) warn_exit(do_lang_tempcode('SEARCH_HOOK_NOT_AVAILABLE'));

			if (array_key_exists('user_label',$info)) $user_label=$info['user_label'];
			if (array_key_exists('days_label',$info)) $days_label=$info['days_label'];

			$extra_sort_fields=array_key_exists('extra_sort_fields',$info)?$info['extra_sort_fields']:array();

			if (method_exists($object,'ajax_tree'))
			{
				require_javascript('javascript_tree_list');
				require_javascript('javascript_more');
				$ajax=true;
				list($ajax_hook,$ajax_options)=$object->ajax_tree();

				require_code('hooks/systems/ajax_tree/'.$ajax_hook);
				$tree_hook_object=object_factory('Hook_'.$ajax_hook);
				$simple_content=$tree_hook_object->simple(NULL,$ajax_options,preg_replace('#,.*$#','',$search_under));

				$nice_label=$search_under;
				if ($search_under!='')
				{
					$simple_content_evaluated=$simple_content->evaluate();
					$matches=array();
					if (preg_match('#<option [^>]*value="'.str_replace('#','\#',preg_quote($search_under)).'('.((strpos($search_under,',')===false)?',':'').'[^"]*)?"[^>]*>([^>]* &gt; )?([^>]*)</option>#',$simple_content_evaluated,$matches)!=0)
					{
						if (strpos($search_under,',')===false) $search_under=$search_under.$matches[1];
						$nice_label=$matches[3];
					}
				}

				$tree=do_template('FORM_SCREEN_INPUT_TREE_LIST',array('_GUID'=>'25368e562be3b4b9c6163aa008b47c91','NICE_LABEL'=>is_null($nice_label)?'':$nice_label,'END_OF_FORM'=>true,'REQUIRED'=>false,'USE_SERVER_ID'=>false,'NAME'=>'search_under','DEFAULT'=>$search_under,'HOOK'=>$ajax_hook,'ROOT_ID'=>'','OPTIONS'=>serialize($ajax_options)));
			} else
			{
				$ajax=false;
				$tree=form_input_list_entry('!',false,do_lang_tempcode('NA_EM'));
				if (method_exists($object,'get_tree'))
				{
					$tree->attach($object->get_tree($search_under));
				}
			}

			$options=new ocp_tempcode();
			if (array_key_exists('special_on',$info))
				foreach ($info['special_on'] as $name=>$display)
					$options->attach(do_template('SEARCH_FOR_SEARCH_DOMAIN_OPTION',array('_GUID'=>'c1853f42d0a110026453f8b94c9f623c','CHECKED'=>(!is_null($content)) || (get_param_integer('option_'.$id.'_'.$name,0)==1),'NAME'=>'option_'.$id.'_'.$name,'DISPLAY'=>$display)));
			if (array_key_exists('special_off',$info))
				foreach ($info['special_off'] as $name=>$display)
					$options->attach(do_template('SEARCH_FOR_SEARCH_DOMAIN_OPTION',array('_GUID'=>'2223ada7636c85e6879feb9a6f6885d2','CHECKED'=>(get_param_integer('option_'.$id.'_'.$name,0)==1),'NAME'=>'option_'.$id.'_'.$name,'DISPLAY'=>$display)));
			if (method_exists($object,'get_fields'))
			{
				$fields=$object->get_fields();
				foreach ($fields as $field)
				{
					$options->attach(do_template('SEARCH_FOR_SEARCH_DOMAIN_OPTION'.$field['TYPE'],array('_GUID'=>'a223ada7636c85e6879feb9a6f6885d2','NAME'=>'option_'.$field['NAME'],'DISPLAY'=>$field['DISPLAY'],'SPECIAL'=>$field['SPECIAL'],'CHECKED'=>array_key_exists('checked',$field)?$field['CHECKED']:false)));
				}
			}

			$specialisation=do_template('SEARCH_ADVANCED',array('_GUID'=>'fad0c147b8291ba972f105c65715f1ac','AJAX'=>$ajax,'OPTIONS'=>$options,'TREE'=>$tree,'UNDERNEATH'=>$search_under!='-1'));

		} else // General screen
		{
			$map=array('page'=>'_SELF','type'=>'results');
			if ($search_under!='-1') $map['search_under']=$search_under;
			$url=build_url($map,'_SELF',NULL,false,true);

			$search_domains=new ocp_tempcode();
			$_hooks=find_all_hooks('modules','search');
			foreach (array_keys($_hooks) as $hook)
			{
				require_code('hooks/modules/search/'.filter_naughty_harsh($hook));
				$object=object_factory('Hook_search_'.filter_naughty_harsh($hook),true);
				if (is_null($object)) continue;
				$info=$object->info();
				if (is_null($info)) continue;
				$checked=(($info['default']) && ($id=='')) || ($hook==$id);
				if (!is_null($content)) $checked=(get_param_integer('search_'.$hook,0)==1) || (($checked) && (get_param_integer('all_defaults',0)==1));

				$options=((array_key_exists('special_on',$info)) || (array_key_exists('special_off',$info)) || (array_key_exists('extra_sort_fields',$info)) || (method_exists($object,'get_fields')) || (method_exists($object,'get_tree')) || (method_exists($object,'get_ajax_tree')))?build_url(array('page'=>'_SELF','id'=>$hook),'_SELF',NULL,false,true):new ocp_tempcode();

				$search_domains->attach(do_template('SEARCH_FOR_SEARCH_DOMAIN',array('_GUID'=>'3d3099872184923aec0f49388f52c750','ADVANCED_ONLY'=>(array_key_exists('advanced_only',$info)) && ($info['advanced_only']),'CHECKED'=>$checked,'OPTIONS'=>$options,'LANG'=>$info['lang'],'NAME'=>$hook)));
			}

			$specialisation=do_template('SEARCH_DOMAINS',array('_GUID'=>'1fd8718b540ec475988070ee7a444dc1','SEARCH_DOMAINS'=>$search_domains));
		}

		$boolean_operator=get_param('conjunctive_operator','OR');
		$can_order_by_rating=db_has_subqueries($GLOBALS['SITE_DB']->connection_read);
		require_code('form_templates');

		$results			=	get_search_results_of_tabs();
		global $M_SORT_KEY;
		$M_SORT_KEY='num_results';
		uasort($results,'multi_sort');
		$results=array_reverse($results);
		$keys = array_keys($results);
		$hook				=	$keys[0];
		if(intval($results[$hook]['num_results'])==0)	$hook	=	'art';	//if largest search result number is zero, set art tab as default.

		//Load search tab hooks
		require_code('hooks/systems/tab_contents/'.filter_naughty_harsh($hook));
		$object			=	object_factory('Hook_'.filter_naughty_harsh($hook),true);
		$default_tab	=	$object->get_content($results[$hook]);

		return do_template('SEARCH_FORM_SCREEN',array('_GUID'=>'8bb208185740183323a6fe6e89d55de5','CAN_ORDER_BY_RATING'=>$can_order_by_rating,'EXTRA_SORT_FIELDS'=>$extra_sort_fields,'USER_LABEL'=>$user_label,'DAYS_LABEL'=>$days_label,'BOOLEAN_SEARCH'=>(get_param_integer('boolean_search',0)==1),'AND'=>$boolean_operator=='AND','CONTENT'=>$content,'TITLE'=>$title,'DEFAULT_TAB'=>$default_tab,'URL'=>get_self_url(),'ART_RES_CNT'=>strval($results['art']['num_results']),'ARTIST_RES_CNT'=>strval($results['artist']['num_results']),'PROJECTS_RES_CNT'=>strval($results['projects']['num_results']),'VENUE_RES_CNT'=>''/*todo*/,'NEWS_RES_CNT'=>strval($results['news']['num_results']),'ACTIVE_TAB'=>$hook));
	}

	/**
	 * The actualiser of a search.
	 *
	 * @param  ID_TEXT		Codename for what's being searched (blank: mixed search)
	 * @param  string			Author name
	 * @param  ?AUTO_LINK	Author ID (NULL: none given)
	 * @param  integer		Days to search
	 * @param  ID_TEXT		Sort key
	 * @param  ID_TEXT		Sort direction
	 * @set    ASC DESC
	 * @param  boolean		Whether to only search titles
	 * @param  string			Comma-separated list of categories to search under
	 * @return array			A triple: The results, results browser, the number of results
	 */
	function results($id,$author,$author_id,$days,$sort,$direction,$only_titles,$search_under)
	{
		$title=get_page_title('RESULTS');

		cache_module_installed_status();

		$cutoff=($days==-1)?NULL:(time()-$days*24*60*60);

		// What we're searching for
		$content=get_param('content',false,true);

		// Search keyword highlighting in any loaded Comcode
		global $SEARCH__CONTENT_BITS;
		$_content_bits=explode(' ',str_replace('"','',str_replace('+','',str_replace('-','',$content))));
		$SEARCH__CONTENT_BITS=array();
		foreach ($_content_bits as $content_bit)
		{
			if (trim($content_bit)!='') $SEARCH__CONTENT_BITS[]=$content_bit;
		}

		$start=get_param_integer('start',0);
		$max=get_param_integer('max',10);  // Also see get_search_rows

		$save_title=post_param('save_title','');
		if ((!is_guest()) && ($save_title!='') && ($start==0))
		{
			$GLOBALS['SITE_DB']->query_insert('searches_saved',array(
				's_title'=>$save_title,
				's_member_id'=>get_member(),
				's_time'=>time(),
				's_primary'=>$content,
				's_auxillary'=>serialize(array_merge($_POST,$_GET)),
			));
		}

		$boolean_operator=get_param('conjunctive_operator','OR');
		list($content_where,$content_explode)=build_content_where($content,get_param_integer('boolean_search',0)==1,$boolean_operator);

		// Search under all hooks we've asked to search under
		$results=array();
		$_hooks=find_all_hooks('modules','search');
		foreach (array_keys($_hooks) as $hook)
		{
			require_code('hooks/modules/search/'.filter_naughty_harsh($hook));
			$object=object_factory('Hook_search_'.filter_naughty_harsh($hook),true);
			if (is_null($object)) continue;
			$info=$object->info();
			if (is_null($info)) continue;

			$test=get_param_integer('search_'.$hook,0);

			if ((($test==1) || ((get_param_integer('all_defaults',0)==1) && ($info['default'])) || ($id==$hook))/* && (($id=='') || ($id==$hook))*/)
			{
				// Category filter
				if (($search_under!='!') && ($search_under!='-1') && (array_key_exists('category',$info)))
				{
					$cats=explode(',',$search_under);
					$where_clause='(';
					foreach ($cats as $cat)
					{
						if (trim($cat)=='') continue;

						if ($where_clause!='(') $where_clause.=' OR ';
						if ($info['integer_category'])
						{
							$where_clause.='r.'.$info['category'].'='.strval((integer)$cat);
						} else
						{
							$where_clause.=db_string_equal_to('r.'.$info['category'],$cat);
						}
					}
					$where_clause.=')';
				} else $where_clause='';

				$only_search_meta=get_param_integer('only_search_meta',0)==1;
				$direction=get_param('direction','ASC');
				$max=get_param_integer('max',10);
				$start=get_param_integer('start',0);
				$hook_results=$object->run($content_explode,$only_search_meta,$direction,$max,$start,$only_titles,$content_where,$author,$author_id,$cutoff,$sort,$id,$boolean_operator,$where_clause,$search_under,get_param_integer('boolean_search',0));
				if (is_null($hook_results)) continue;
				foreach ($hook_results as $i=>$result)
				{
					$result['object']=$object;
					$hook_results[$i]=$result;
				}

				$results=sort_search_results($hook_results,$results,$direction);
			}
		}

		// Now glue our templates together
		$out=new ocp_tempcode();
		$i=0;
		global $CATALOGUE_ENTRIES_BUILDUP;
		$CATALOGUE_ENTRIES_BUILDUP=array();
		$tabular_results=array();

		foreach ($results as $result)
		{
			if (array_key_exists('restricted',$result)) continue; // This has been blanked out due to insufficient access permissions or some other reason

			if ($i>=$start+$max) break;

			if ($i>=$start)
			{
				if (array_key_exists('template',$result))
				{
					$rendered_result=$result['template'];
				} else
				{
					if (($id!='') && (method_exists($result['object'],'render_tabular')))
					{
						$rendered_result=$result['object']->render_tabular($result['data']);
					} else
					{
						$rendered_result=$result['object']->render($result['data']);
					}
				}
				if (!is_null($rendered_result))
				{
					if (is_array($rendered_result))
					{
						$class=get_class($result['object']);
						if (!array_key_exists($class,$tabular_results)) $tabular_results[$class]=array();
						$tabular_results[$class][]=$rendered_result;
					} else
					{
						$out->attach(do_template('SEARCH_RESULT',array('_GUID'=>'47da093f9ace87819e246f0cec1402a9','CONTENT'=>$rendered_result)));
					}
				}
			}
			$i++;
		}
		foreach ($tabular_results as $tabular_type=>$types_results)
		{
			// Normalisation process
			$ultimate_field_map=array();
			foreach ($types_results as $r)
				$ultimate_field_map+=$r;
			//ksort($ultimate_field_map);
			$ultimate_field_map=array_keys($ultimate_field_map);
			foreach ($types_results as $i=>$r)
			{
				$r2d2=array();
				foreach ($ultimate_field_map as $key)
				{
					if (!array_key_exists($key,$r)) $r[$key]='';
					$r2d2[$key]=$r[$key];
				}
				//ksort($r);
				$r=$r2d2;
				$types_results[$i]=array('R'=>$r);
			}
			// Output
			$out->attach(do_template('SEARCH_RESULT_TABLE',array('HEADERS'=>$ultimate_field_map,'ROWS'=>$types_results)));
		}
		if (count($CATALOGUE_ENTRIES_BUILDUP)!=0)
		{
			global $SEARCH_CATALOGUE_ENTRIES_CATALOGUES;
			foreach ($CATALOGUE_ENTRIES_BUILDUP as $catalogue_name=>$catalogue_entries)
			{
				$tpl_set=$catalogue_name;
				$buildup=get_catalogue_category_entry_buildup(NULL,$catalogue_name,$SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name],'SEARCH',$tpl_set,NULL,NULL,NULL,-1,NULL,false,$catalogue_entries);
				$out->attach(do_template('SEARCH_RESULT_CATALOGUE_ENTRIES',array('_GUID'=>'dd0045ac291275b2d822d40b28182a28','BUILDUP'=>$buildup[0],'NAME'=>$catalogue_name,'TITLE'=>get_translated_text($SEARCH_CATALOGUE_ENTRIES_CATALOGUES[$catalogue_name]['c_title']))));
			}
		}

		$GLOBALS['META_DATA']+=array(
			'opensearch_totalresults'=>strval($i),
			'opensearch_startindex'=>strval($start),
			'opensearch_itemsperpage'=>strval($max),
		);

		$SEARCH__CONTENT_BITS=NULL;

		$out=build_search_results_interface($results,$start,$max,$direction);
		if ($out->is_empty()) return array(new ocp_tempcode(),new ocp_tempcode(),0);

		require_code('templates_results_browser');
		$results_browser=results_browser(do_lang_tempcode('RESULTS'),NULL,$start,'start',$max,'max',$GLOBALS['TOTAL_RESULTS'],NULL,'results',true,true);

		if ($start==0)
		{
			if ((get_db_type()!='xml') || (get_param_integer('keep_testing_logging',0)==1))
			{
				$GLOBALS['SITE_DB']->query_insert('searches_logged',array(
					's_member_id'=>get_member(),
					's_time'=>time(),
					's_primary'=>$content,
					's_auxillary'=>serialize(array_merge($_POST,$_GET)),
					's_num_results'=>count($results),
				));
			}
		}

		return array($out,$results_browser,$GLOBALS['TOTAL_RESULTS']);
	}

	/**
	 * Result links redirect
	 *
	 * @param  ID_TEXT		Codename for what's being searched (blank: mixed search)
	 * @return array			A triple: The results, results browser, the number of results
	 */
	function result_link_redirect()
	{
		$redirect	=	base64_decode(get_param('redirect'));
		if((is_guest()) && (strpos($redirect,'members')===false))
			$redirect	=	build_url(array('page'=>'search','type'=>'guest_join'),get_module_zone('search'));
		$title			=	get_page_title('SEARCH');
		$message			=	do_lang_tempcode('NO_ACCESS_TO_GUESTS');
		return redirect_screen($title,$redirect,'');
	}

	/**
	 * Search content access denied screen
	 *
	 * @param  ID_TEXT		Codename for what's being searched (blank: mixed search)
	 * @return array			A triple: The results, results browser, the number of results
	 */
	function join_for_access()
	{
		$title	=	get_page_title('ACCESS_DENIED');
		$message	=	do_lang_tempcode('NO_ACCESS_TO_GUESTS');

		breadcrumb_set_parents(array(array('_SELF:_SELF:misc',do_lang_tempcode('RESULT'))));
		breadcrumb_set_self(do_lang_tempcode('ACCESS_DENIED'));

		$redirect	=	build_url(array('page'=>'join','type'=>'misc'),get_module_zone('join'));
		return do_template('SEARCH_CONTENT_GUEST_SIGNUP',array('TITLE'=>$title,'MESSAGE'=>$message,'JOIN_URL'=>$redirect));
	}
}


