// UIActivityIndicatorView+AFNetworking.h
//
// Copyright (c) 2013-2014 AFNetworking (http://afnetworking.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
import Foundation
import Availability
#if defined(__IPHONE_OS_VERSION_MIN_REQUIRED)
import UIKit

/**
 This category adds methods to the UIKit framework's `UIActivityIndicatorView` class. The methods in this category provide support for automatically starting and stopping animation depending on the loading state of a request operation or session task.
 */
extension UIActivityIndicatorView {
    ///----------------------------------
    /// @name Animating for Session Tasks
    ///----------------------------------
    /**
     Binds the animating state to the state of the specified task.
    
     @param task The task. If `nil`, automatic updating from any previously specified operation will be disabled.
     */
#if __IPHONE_OS_VERSION_MIN_REQUIRED >= 70000
    func setAnimatingWithStateOfTask(task: NSURLSessionTask) {
        var notificationCenter = NSNotificationCenter.defaultCenter()
        notificationCenter.removeObserver(self, name: AFNetworkingTaskDidResumeNotification, object: nil)
        notificationCenter.removeObserver(self, name: AFNetworkingTaskDidSuspendNotification, object: nil)
        notificationCenter.removeObserver(self, name: AFNetworkingTaskDidCompleteNotification, object: nil)
        if task {
            if task.state != NSURLSessionTaskStateCompleted {
                if task.state == NSURLSessionTaskStateRunning {
                    self.startAnimating()
                }
                else {
                    self.stopAnimating()
                }
                notificationCenter.addObserver(self, selector: #selector(self.af_startAnimating), name: AFNetworkingTaskDidResumeNotification, object: task)
                notificationCenter.addObserver(self, selector: #selector(self.af_stopAnimating), name: AFNetworkingTaskDidCompleteNotification, object: task)
                notificationCenter.addObserver(self, selector: #selector(self.af_stopAnimating), name: AFNetworkingTaskDidSuspendNotification, object: task)
            }
        }
    }
#endif
    ///---------------------------------------
    /// @name Animating for Request Operations
    ///---------------------------------------
    /**
     Binds the animating state to the execution state of the specified operation.
     
     @param operation The operation. If `nil`, automatic updating from any previously specified operation will be disabled.
     */

    func setAnimatingWithStateOfOperation(operation: AFURLConnectionOperation) {
        var notificationCenter = NSNotificationCenter.defaultCenter()
        notificationCenter.removeObserver(self, name: AFNetworkingOperationDidStartNotification, object: nil)
        notificationCenter.removeObserver(self, name: AFNetworkingOperationDidFinishNotification, object: nil)
        if operation {
            if !operation.isFinished() {
                if operation.isExecuting() {
                    self.startAnimating()
                }
                else {
                    self.stopAnimating()
                }
                notificationCenter.addObserver(self, selector: #selector(self.af_startAnimating), name: AFNetworkingOperationDidStartNotification, object: operation)
                notificationCenter.addObserver(self, selector: #selector(self.af_stopAnimating), name: AFNetworkingOperationDidFinishNotification, object: operation)
            }
        }
    }

#if __IPHONE_OS_VERSION_MIN_REQUIRED >= 70000
#endif
// MARK: -
// MARK: -

    func af_startAnimating() {
        dispatch_async(dispatch_get_main_queue(), {() -> Void in
            self.startAnimating()
        })
    }

    func af_stopAnimating() {
        dispatch_async(dispatch_get_main_queue(), {() -> Void in
            self.stopAnimating()
        })
    }
}
#endif
// UIActivityIndicatorView+AFNetworking.m
//
// Copyright (c) 2013-2014 AFNetworking (http://afnetworking.com)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
#if defined(__IPHONE_OS_VERSION_MIN_REQUIRED)
#if __IPHONE_OS_VERSION_MIN_REQUIRED >= 70000
#endif