//
//  RSSParser.h
//  RSSParser
//
//  Created by Thibaut LE LEVIER on 1/31/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//
import UIKit
import Foundation
class RSSParser: NSObject, NSXMLParserDelegate {
    var currentItem: RSSItem!
    var items = [AnyObject]()
    var tmpString = ""
    var block = Void()
    var failblock = Void()

    class func parseRSSFeedForRequest(urlRequest: NSURLRequest, success: (feedItems: [AnyObject]) -> Void, failure: (error: NSError) -> Void) {
        var parser = RSSParser()
        parser.parseRSSFeedForRequest(urlRequest, success: success, failure: failure)
    }

    func parseRSSFeedForRequest(urlRequest: NSURLRequest, success: (feedItems: [AnyObject]) -> Void, failure: (error: NSError) -> Void) {
        block = success
        var operation = AFHTTPRequestOperation(request: urlRequest)
        operation.responseSerializer = AFXMLParserResponseSerializer()
        operation.responseSerializer.acceptableContentTypes = Set<NSObject>(["application/xml", "text/xml", "application/rss+xml", "application/atom+xml"])
        operation.setCompletionBlockWithSuccess({(operation: AFHTTPRequestOperation, responseObject: AnyObject) -> Void in
            failblock = failure
            (responseObject as! NSXMLParser).delegate = self
            (responseObject as! NSXMLParser).parse()
        }, failure: {(operation: AFHTTPRequestOperation, error: NSError) -> Void in
            failure(error)
        })
        operation.start()
    }

// MARK: lifecycle

    override init() {
        super.init()
        
        items = [AnyObject]()
    
    }
// MARK: -
// MARK: parser
// MARK: -
// MARK: NSXMLParser delegate

    func parser(parser: NSXMLParser, didStartElement elementName: String, namespaceURI: String, qualifiedName: String, attributes attributeDict: [NSObject : AnyObject]) {
        print("ELEMENT NAME IS \(elementName)")
        if (elementName == "item") || (elementName == "entry") {
            currentItem = RSSItem()
        }
        if (elementName == "enclosure") {
            currentItem.enclosureUrl = (attributeDict["url"] as! String)
        }
        tmpString = String()
    }

    func parser(parser: NSXMLParser, didEndElement elementName: String, namespaceURI: String, qualifiedName qName: String) {
        if (elementName == "item") || (elementName == "entry") {
            items.append(currentItem)
        }
        if currentItem != nil && tmpString != nil {
            if (elementName == "title") {
                currentItem.title = tmpString
            }
            if (elementName == "description") {
                currentItem.itemDescription = tmpString
            }
            if (elementName == "content:encoded") || (elementName == "content") {
                currentItem.content = tmpString
            }
            if (elementName == "link") {
                currentItem.link = NSURL(string: tmpString)!
            }
            if (elementName == "comments") {
                currentItem.commentsLink = NSURL(string: tmpString)!
            }
            if (elementName == "wfw:commentRss") {
                currentItem.commentsFeed = NSURL(string: tmpString)!
            }
            if (elementName == "slash:comments") {
                currentItem.commentsCount = Int(Int((tmpString as NSString ?? "0").intValue))
            }
            if (elementName == "pubDate") {
                var formatter = NSDateFormatter()
                var local = NSLocale(localeIdentifier: "en_EN")
                formatter.locale = local
                formatter.dateFormat = "EEE, dd MMM yyyy HH:mm:ss Z"
                currentItem.pubDate = formatter.dateFromString(tmpString)!
            }
            if (elementName == "dc:creator") {
                currentItem.author = tmpString
            }
            if (elementName == "guid") {
                currentItem.guid = tmpString
            }
            if (elementName == "author") {
                currentItem.author = tmpString
            }
            if (elementName == "category") {
                currentItem.category = tmpString
            }
        }
        if (elementName == "rss") || (elementName == "feed") {
            block(items)
        }
    }

    func parser(parser: NSXMLParser, foundCharacters string: String) {
        tmpString += string
    }

    func parser(parser: NSXMLParser, parseErrorOccurred parseError: NSError?) {
        failblock(parseError)
        parser.abortParsing()
    }
}
//
//  RSSParser.m
//  RSSParser
//
//  Created by Thibaut LE LEVIER on 1/31/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//