//
//  RSSItem.h
//  RSSParser
//
//  Created by Thibaut LE LEVIER on 2/3/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//
import UIKit
class RSSItem: NSObject, NSCoding {
    var title = ""
    var itemDescription = ""
    var content = ""
    var link: NSURL!
    var commentsLink: NSURL!
    var commentsFeed: NSURL!
    var commentsCount: Int!
    var pubDate: NSDate!
    var author = ""
    var guid = ""
    var category = ""
    var enclosureUrl = ""

    func imagesFromItemDescription() -> [AnyObject] {
        if self.itemDescription {
            return self.imagesFromHTMLString(self.itemDescription)
        }
        return nil
    }

    func imagesFromContent() -> [AnyObject] {
        if self.content {
            return self.imagesFromHTMLString(self.content)
        }
        return nil
    }

// MARK: - retrieve images from html string using regexp (private methode)

    func imagesFromHTMLString(htmlstr: String) -> [AnyObject] {
        var imagesURLStringArray = [AnyObject]()
        var error: NSError?
        var regex = try! NSRegularExpression(pattern: "(https?)\\S*(png|jpg|jpeg|gif)", options: NSRegularExpressionCaseInsensitive)
        regex.enumerateMatchesInString(htmlstr, options: [], range: NSMakeRange(0, htmlstr.length), usingBlock: {(result: NSTextCheckingResult, flags: NSMatchingFlags, stop: Bool) -> Void in
            imagesURLStringArray.append(htmlstr.substringWithRange(result.range))
        })
        return [AnyObject](arrayLiteral: imagesURLStringArray)
    }
// MARK: - NSCoding

    required init?(coder aDecoder: NSCoder) {
        super.init()

        self.title = aDecoder.decodeObjectForKey("title")!
        self.itemDescription = aDecoder.decodeObjectForKey("itemDescription")!
        self.content = aDecoder.decodeObjectForKey("content")!
        self.link = aDecoder.decodeObjectForKey("link")!
        self.commentsLink = aDecoder.decodeObjectForKey("commentsLink")!
        self.commentsFeed = aDecoder.decodeObjectForKey("commentsFeed")!
        self.commentsCount = aDecoder.decodeObjectForKey("commentsCount")!
        self.pubDate = aDecoder.decodeObjectForKey("pubDate")!
        self.author = aDecoder.decodeObjectForKey("author")!
        self.guid = aDecoder.decodeObjectForKey("guid")!
    
    }

    override func encodeWithCoder(aCoder: NSCoder) {
        aCoder.encodeObject(self.title, forKey: "title")
        aCoder.encodeObject(self.itemDescription, forKey: "itemDescription")
        aCoder.encodeObject(self.content, forKey: "content")
        aCoder.encodeObject(self.link, forKey: "link")
        aCoder.encodeObject(self.commentsLink, forKey: "commentsLink")
        aCoder.encodeObject(self.commentsFeed, forKey: "commentsFeed")
        aCoder.encodeObject(self.commentsCount, forKey: "commentsCount")
        aCoder.encodeObject(self.pubDate, forKey: "pubDate")
        aCoder.encodeObject(self.author, forKey: "author")
        aCoder.encodeObject(self.guid, forKey: "guid")
    }
// MARK: -

    override func isEqual(object: RSSItem) -> Bool {
        return (self.link.absoluteString == object.link.absoluteString)
    }

    override func hash() -> Int {
        return self.link.hash
    }

    override func description() -> String {
        return "<\(self.self): \(self.title.stringByTrimmingCharactersInSet<NSObject>(NSCharacterSet.whitespaceCharacterSet<NSObject>()))>"
    }
}
//
//  RSSItem.m
//  RSSParser
//
//  Created by Thibaut LE LEVIER on 2/3/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//
extension RSSItem {
    func imagesFromHTMLString(htmlstr: String) -> [AnyObject] {
    }
}