//
//  JSONKit.h
//  http://github.com/johnezang/JSONKit
//  Dual licensed under either the terms of the BSD License, or alternatively
//  under the terms of the Apache License, Version 2.0, as specified below.
//
/*
 Copyright (c) 2011, John Engelhart
 
 All rights reserved.
 
 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:
 
 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.
 
 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.
 
 * Neither the name of the Zang Industries nor the names of its
 contributors may be used to endorse or promote products derived from
 this software without specific prior written permission.
 
 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
 Copyright 2011 John Engelhart
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/
#if    __OBJC__
import UIKit
import Foundation
import Foundation
import Foundation
import Foundation
import Foundation
import Foundation
#endif // __OBJC__
#if __cplusplus

#endif
// For Mac OS X < 10.5.
#if !  NSINTEGER_DEFINED
//#define   NSINTEGER_DEFINED
#if       defined(__LP64__) || defined(NS_BUILD_32_LIKE_64)
var NSInteger = 0

var NSUInteger = 0

let NSIntegerMin = LONG_MIN
let NSIntegerMax = LONG_MAX
let NSUIntegerMax = ULONG_MAX
#else  // defined(__LP64__) || defined(NS_BUILD_32_LIKE_64)
var NSInteger = 0

var NSUInteger = 0

let NSIntegerMin = INT_MIN
let NSIntegerMax = INT_MAX
let NSUIntegerMax = UINT_MAX
#endif // defined(__LP64__) || defined(NS_BUILD_32_LIKE_64)
#endif // NSINTEGER_DEFINED
#if !_JSONKIT_H_
//#define _JSONKIT_H_
#if defined(__GNUC__) && (__GNUC__ >= 4) && defined(__APPLE_CC__) && (__APPLE_CC__ >= 5465)
let JK_DEPRECATED_ATTRIBUTE = (deprecated)
#else
//#define JK_DEPRECATED_ATTRIBUTE
#endif
let JSONKIT_VERSION_MAJOR = 1
let JSONKIT_VERSION_MINOR = 4
var JKFlags = 0

/*
  JKParseOptionComments        : Allow C style // and /_* ... *_/ (without a _, obviously) comments in JSON.
  JKParseOptionUnicodeNewlines : Allow Unicode recommended (?:\r\n|[\n\v\f\r\x85\p{Zl}\p{Zp}]) newlines.
  JKParseOptionLooseUnicode    : Normally the decoder will stop with an error at any malformed Unicode.
                                 This option allows JSON with malformed Unicode to be parsed without reporting an error.
                                 Any malformed Unicode is replaced with \uFFFD, or "REPLACEMENT CHARACTER".
 */
enum ObjCEnum2 : Int {
    case JKParseOptionNone = 0
    case JKParseOptionStrict = 0
    static let JKParseOptionComments:  = (1 << 0)
    static let JKParseOptionUnicodeNewlines:  = (1 << 1)
    static let JKParseOptionLooseUnicode:  = (1 << 2)
    static let JKParseOptionPermitTextAfterValidJSON:  = (1 << 3)
    static let JKParseOptionValidFlags:  = ([.JKParseOptionComments, .JKParseOptionUnicodeNewlines, .JKParseOptionLooseUnicode, .JKParseOptionPermitTextAfterValidJSON])
}

var JKParseOptionFlags = JKFlags()

enum ObjCEnum3 : Int {
    case JKSerializeOptionNone = 0
    static let JKSerializeOptionPretty:  = (1 << 0)
    static let JKSerializeOptionEscapeUnicode:  = (1 << 1)
    static let JKSerializeOptionEscapeForwardSlashes:  = (1 << 4)
    static let JKSerializeOptionValidFlags:  = ([.JKSerializeOptionPretty, .JKSerializeOptionEscapeUnicode, .JKSerializeOptionEscapeForwardSlashes])
}

var JKSerializeOptionFlags = JKFlags()

#if    __OBJC__
var JKParseState = structJKParseState()

// Opaque internal, private type.
// As a general rule of thumb, if you use a method that doesn't accept a JKParseOptionFlags argument, it defaults to JKParseOptionStrict
class JSONDecoder: NSObject {
    var parseState: JKParseState!

    class func decoder() -> AnyObject {
    }

    class func decoderWithParseOptions(parseOptionFlags: JKParseOptionFlags) -> AnyObject {
    }

    override init(parseOptions parseOptionFlags: JKParseOptionFlags) {
    }

    func clearCache() {
    }
    // The parse... methods were deprecated in v1.4 in favor of the v1.4 objectWith... methods.

    func parseUTF8String(string: UInt8, length: size_t) -> AnyObject {
    }
    // Deprecated in JSONKit v1.4.  Use objectWithUTF8String:length:        instead.

    func parseUTF8String(string: UInt8, length: size_t, error: NSError?) -> AnyObject {
    }
    // Deprecated in JSONKit v1.4.  Use objectWithUTF8String:length:error:  instead.
    // The NSData MUST be UTF8 encoded JSON.

    func parseJSONData(jsonData: NSData) -> AnyObject {
    }
    // Deprecated in JSONKit v1.4.  Use objectWithData:                     instead.

    func parseJSONData(jsonData: NSData, error: NSError?) -> AnyObject {
    }
    // Deprecated in JSONKit v1.4.  Use objectWithData:error:               instead.
    // Methods that return immutable collection objects.

    func objectWithUTF8String(string: UInt8, length: Int) -> AnyObject {
    }

    func objectWithUTF8String(string: UInt8, length: Int, error: NSError?) -> AnyObject {
    }
    // The NSData MUST be UTF8 encoded JSON.

    func objectWithData(jsonData: NSData) -> AnyObject {
    }

    func objectWithData(jsonData: NSData, error: NSError?) -> AnyObject {
    }
    // Methods that return mutable collection objects.

    func mutableObjectWithUTF8String(string: UInt8, length: Int) -> AnyObject {
    }

    func mutableObjectWithUTF8String(string: UInt8, length: Int, error: NSError?) -> AnyObject {
    }
    // The NSData MUST be UTF8 encoded JSON.

    func mutableObjectWithData(jsonData: NSData) -> AnyObject {
    }

    func mutableObjectWithData(jsonData: NSData, error: NSError?) -> AnyObject {
    }
}
////////////
// MARK: Deserializing methods
////////////
extension NSString {
    func objectFromJSONString() -> AnyObject {
    }

    func objectFromJSONStringWithParseOptions(parseOptionFlags: JKParseOptionFlags) -> AnyObject {
    }

    func objectFromJSONStringWithParseOptions(parseOptionFlags: JKParseOptionFlags, error: NSError?) -> AnyObject {
    }

    func mutableObjectFromJSONString() -> AnyObject {
    }

    func mutableObjectFromJSONStringWithParseOptions(parseOptionFlags: JKParseOptionFlags) -> AnyObject {
    }

    func mutableObjectFromJSONStringWithParseOptions(parseOptionFlags: JKParseOptionFlags, error: NSError?) -> AnyObject {
    }
}
extension NSData {
    // The NSData MUST be UTF8 encoded JSON.
    func objectFromJSONData() -> AnyObject {
    }

    func objectFromJSONDataWithParseOptions(parseOptionFlags: JKParseOptionFlags) -> AnyObject {
    }

    func objectFromJSONDataWithParseOptions(parseOptionFlags: JKParseOptionFlags, error: NSError?) -> AnyObject {
    }

    func mutableObjectFromJSONData() -> AnyObject {
    }

    func mutableObjectFromJSONDataWithParseOptions(parseOptionFlags: JKParseOptionFlags) -> AnyObject {
    }

    func mutableObjectFromJSONDataWithParseOptions(parseOptionFlags: JKParseOptionFlags, error: NSError?) -> AnyObject {
    }
}
////////////
// MARK: Serializing methods
////////////
extension NSString {
    // Convenience methods for those that need to serialize the receiving NSString (i.e., instead of having to serialize a NSArray with a single NSString, you can "serialize to JSON" just the NSString).
    // Normally, a string that is serialized to JSON has quotation marks surrounding it, which you may or may not want when serializing a single string, and can be controlled with includeQuotes:
    // includeQuotes:YES `a "test"...` -> `"a \"test\"..."`
    // includeQuotes:NO  `a "test"...` -> `a \"test\"...`
    func JSONData() -> NSData {
    }
    // Invokes JSONDataWithOptions:JKSerializeOptionNone   includeQuotes:YES

    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, includeQuotes: Bool, error: NSError?) -> NSData {
    }

    func JSONString() -> String {
    }
    // Invokes JSONStringWithOptions:JKSerializeOptionNone includeQuotes:YES

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, includeQuotes: Bool, error: NSError?) -> String {
    }
}
extension NSArray {
    func JSONData() -> NSData {
    }

    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, error: NSError?) -> NSData {
    }

    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingDelegate delegate: AnyObject, selector: Selector, error: NSError?) -> NSData {
    }

    func JSONString() -> String {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, error: NSError?) -> String {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingDelegate delegate: AnyObject, selector: Selector, error: NSError?) -> String {
    }
}
extension NSDictionary {
    func JSONData() -> NSData {
    }

    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, error: NSError?) -> NSData {
    }

    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingDelegate delegate: AnyObject, selector: Selector, error: NSError?) -> NSData {
    }

    func JSONString() -> String {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, error: NSError?) -> String {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingDelegate delegate: AnyObject, selector: Selector, error: NSError?) -> String {
    }
}
#if __BLOCKS__
extension NSArray {
    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingBlock block: (object: AnyObject) -> AnyObject, error: NSError?) -> NSData {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingBlock block: (object: AnyObject) -> AnyObject, error: NSError?) -> String {
    }
}
extension NSDictionary {
    func JSONDataWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingBlock block: (object: AnyObject) -> AnyObject, error: NSError?) -> NSData {
    }

    func JSONStringWithOptions(serializeOptions: JKSerializeOptionFlags, serializeUnsupportedClassesUsingBlock block: (object: AnyObject) -> AnyObject, error: NSError?) -> String {
    }
}
// extern "C"
#endif
//
//  JSONKit.m
//  http://github.com/johnezang/JSONKit
//  Dual licensed under either the terms of the BSD License, or alternatively
//  under the terms of the Apache License, Version 2.0, as specified below.
//
/*
 Copyright (c) 2011, John Engelhart

 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright
 notice, this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright
 notice, this list of conditions and the following disclaimer in the
 documentation and/or other materials provided with the distribution.

 * Neither the name of the Zang Industries nor the names of its
 contributors may be used to endorse or promote products derived from
 this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*
 Copyright 2011 John Engelhart

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/
/*
  Acknowledgments:

  The bulk of the UTF8 / UTF32 conversion and verification comes
  from ConvertUTF.[hc].  It has been modified from the original sources.

  The original sources were obtained from http://www.unicode.org/.
  However, the web site no longer seems to host the files.  Instead,
  the Unicode FAQ http://www.unicode.org/faq//utf_bom.html#gen4
  points to International Components for Unicode (ICU)
  http://site.icu-project.org/ as an example of how to write a UTF
  converter.

  The decision to use the ConvertUTF.[ch] code was made to leverage
  "proven" code.  Hopefully the local modifications are bug free.

  The code in isValidCodePoint() is derived from the ICU code in
  utf.h for the macros U_IS_UNICODE_NONCHAR and U_IS_UNICODE_CHAR.

  From the original ConvertUTF.[ch]:

 * Copyright 2001-2004 Unicode, Inc.
 * 
 * Disclaimer
 * 
 * This source code is provided as is by Unicode, Inc. No claims are
 * made as to fitness for any particular purpose. No warranties of any
 * kind are expressed or implied. The recipient agrees to determine
 * applicability of information provided. If this file has been
 * purchased on magnetic or optical media from Unicode, Inc., the
 * sole remedy for any claim will be exchange of defective media
 * within 90 days of receipt.
 * 
 * Limitations on Rights to Redistribute This Code
 * 
 * Unicode, Inc. hereby grants the right to freely use the information
 * supplied in this file in the creation of products supporting the
 * Unicode Standard, and to make copies of this file in any form
 * for internal or external distribution as long as this notice
 * remains attached.

*/
//#pragma GCC diagnostic ignored "-Wdeprecated-objc-pointer-introspection"
//#include <CoreFoundation/CoreFoundation.h>
//#import <Foundation/Foundation.h>
import Foundation
import Foundation
import Foundation
import Foundation
import Foundation
import Foundation
import Foundation
#if !__has_feature
//#define __has_feature(x) 0
#endif
#if JK_ENABLE_CF_TRANSFER_OWNERSHIP_CALLBACKS
#endif
#if __OBJC_GC__
#endif
#if __has_feature(objc_arc)
#endif
// The following checks are really nothing more than sanity checks.
// JSONKit technically has a few problems from a "strictly C99 conforming" standpoint, though they are of the pedantic nitpicking variety.
// In practice, though, for the compilers and architectures we can reasonably expect this code to be compiled for, these pedantic nitpicks aren't really a problem.
// Since we're limited as to what we can do with pre-processor #if checks, these checks are not nearly as through as they should be.
#if (UINT_MAX != 0xffffffffU) || (INT_MIN != (-0x7fffffff-1)) || (ULLONG_MAX != 0xffffffffffffffffULL) || (LLONG_MIN != (-0x7fffffffffffffffLL-1LL))
#endif
#if !defined(__LP64__) && ((UINT_MAX != ULONG_MAX) || (INT_MAX != LONG_MAX) || (INT_MIN != LONG_MIN) || (WORD_BIT != LONG_BIT))
#endif
// Cocoa / Foundation uses NS*Integer as the type for a lot of arguments.  We make sure that NS*Integer is something we are expecting and is reasonably compatible with size_t / ssize_t
#if (NSUIntegerMax != ULONG_MAX) || (NSIntegerMax != LONG_MAX) || (NSIntegerMin != LONG_MIN)
#endif
#if (NSUIntegerMax != SIZE_MAX) || (NSIntegerMax != SSIZE_MAX)
#endif
// For DJB hash.
let JK_HASH_INIT = (1402737925UL)
// Use __builtin_clz() instead of trailingBytesForUTF8[] table lookup.
//#define JK_FAST_TRAILING_BYTES
// JK_CACHE_SLOTS must be a power of 2.  Default size is 1024 slots.
let JK_CACHE_SLOTS_BITS = (10)
let JK_CACHE_SLOTS = (1UL << JK_CACHE_SLOTS_BITS)
// JK_CACHE_PROBES is the number of probe attempts.
let JK_CACHE_PROBES = (4UL)
// JK_INIT_CACHE_AGE must be < (1 << AGE) - 1, where AGE is sizeof(typeof(AGE)) * 8.
let JK_INIT_CACHE_AGE = (0)
// JK_TOKENBUFFER_SIZE is the default stack size for the temporary buffer used to hold "non-simple" strings (i.e., contains \ escapes)
let JK_TOKENBUFFER_SIZE = (1024UL * 2UL)
// JK_STACK_OBJS is the default number of spaces reserved on the stack for temporarily storing pointers to Obj-C objects before they can be transferred to a NSArray / NSDictionary.
let JK_STACK_OBJS = (1024UL * 1UL)
let JK_JSONBUFFER_SIZE = (1024UL * 4UL)
let JK_UTF8BUFFER_SIZE = (1024UL * 16UL)
let JK_ENCODE_CACHE_SLOTS = (1024UL)
#if       defined (__GNUC__) && (__GNUC__ >= 4)
//#define JK_ATTRIBUTES(attr, ...)        __attribute__((attr, ##__VA_ARGS__))
//#define JK_EXPECTED(cond, expect)       __builtin_expect((long)(cond), (expect))
//#define JK_EXPECT_T(cond)               JK_EXPECTED(cond, 1U)
//#define JK_EXPECT_F(cond)               JK_EXPECTED(cond, 0U)
//#define JK_PREFETCH(ptr)                __builtin_prefetch(ptr)
#else  // defined (__GNUC__) && (__GNUC__ >= 4) 
//#define JK_ATTRIBUTES(attr, ...)
//#define JK_EXPECTED(cond, expect)       (cond)
//#define JK_EXPECT_T(cond)               (cond)
//#define JK_EXPECT_F(cond)               (cond)
//#define JK_PREFETCH(ptr)
#endif // defined (__GNUC__) && (__GNUC__ >= 4) 
let JK_STATIC_INLINE = __inline__(always_inline)
//#define JK_ALIGNED(arg)                                            JK_ATTRIBUTES(aligned(arg))
let JK_UNUSED_ARG = JK_ATTRIBUTES(unused)
let JK_WARN_UNUSED = JK_ATTRIBUTES(warn_unused_result)
let JK_WARN_UNUSED_CONST = JK_ATTRIBUTES(warn_unused_result, const)
let JK_WARN_UNUSED_PURE = JK_ATTRIBUTES(warn_unused_result, pure)
let JK_WARN_UNUSED_SENTINEL = JK_ATTRIBUTES(warn_unused_result, sentinel)
//#define JK_NONNULL_ARGS(arg, ...)                                  JK_ATTRIBUTES(nonnull(arg, ##__VA_ARGS__))
//#define JK_WARN_UNUSED_NONNULL_ARGS(arg, ...)                      JK_ATTRIBUTES(warn_unused_result, nonnull(arg, ##__VA_ARGS__))
//#define JK_WARN_UNUSED_CONST_NONNULL_ARGS(arg, ...)                JK_ATTRIBUTES(warn_unused_result, const, nonnull(arg, ##__VA_ARGS__))
//#define JK_WARN_UNUSED_PURE_NONNULL_ARGS(arg, ...)                 JK_ATTRIBUTES(warn_unused_result, pure, nonnull(arg, ##__VA_ARGS__))
#if       defined (__GNUC__) && (__GNUC__ >= 4) && (__GNUC_MINOR__ >= 3)
//#define JK_ALLOC_SIZE_NON_NULL_ARGS_WARN_UNUSED(as, nn, ...) JK_ATTRIBUTES(warn_unused_result, nonnull(nn, ##__VA_ARGS__), alloc_size(as))
#else  // defined (__GNUC__) && (__GNUC__ >= 4) && (__GNUC_MINOR__ >= 3)
//#define JK_ALLOC_SIZE_NON_NULL_ARGS_WARN_UNUSED(as, nn, ...) JK_ATTRIBUTES(warn_unused_result, nonnull(nn, ##__VA_ARGS__))
#endif // defined (__GNUC__) && (__GNUC__ >= 4) && (__GNUC_MINOR__ >= 3)

enum ObjCEnum4 : Int {
    case JSONNumberStateStart = 0
    case JSONNumberStateFinished = 1
    case JSONNumberStateError = 2
    case JSONNumberStateWholeNumberStart = 3
    case JSONNumberStateWholeNumberMinus = 4
    case JSONNumberStateWholeNumberZero = 5
    case JSONNumberStateWholeNumber = 6
    case JSONNumberStatePeriod = 7
    case JSONNumberStateFractionalNumberStart = 8
    case JSONNumberStateFractionalNumber = 9
    case JSONNumberStateExponentStart = 10
    case JSONNumberStateExponentPlusMinus = 11
    case JSONNumberStateExponent = 12
}

enum ObjCEnum5 : Int {
    case JSONStringStateStart = 0
    case JSONStringStateParsing = 1
    case JSONStringStateFinished = 2
    case JSONStringStateError = 3
    case JSONStringStateEscape = 4
    case JSONStringStateEscapedUnicode1 = 5
    case JSONStringStateEscapedUnicode2 = 6
    case JSONStringStateEscapedUnicode3 = 7
    case JSONStringStateEscapedUnicode4 = 8
    case JSONStringStateEscapedUnicodeSurrogate1 = 9
    case JSONStringStateEscapedUnicodeSurrogate2 = 10
    case JSONStringStateEscapedUnicodeSurrogate3 = 11
    case JSONStringStateEscapedUnicodeSurrogate4 = 12
    case JSONStringStateEscapedNeedEscapeForSurrogate = 13
    case JSONStringStateEscapedNeedEscapedUForSurrogate = 14
}

enum ObjCEnum6 : Int {
    static let JKParseAcceptValue:  = (1 << 0)
    static let JKParseAcceptComma:  = (1 << 1)
    static let JKParseAcceptEnd:  = (1 << 2)
    static let JKParseAcceptValueOrEnd:  = ([.JKParseAcceptValue, .JKParseAcceptEnd])
    static let JKParseAcceptCommaOrEnd:  = ([.JKParseAcceptComma, .JKParseAcceptEnd])
}

enum ObjCEnum7 : Int {
    case JKClassUnknown = 0
    case JKClassString = 1
    case JKClassNumber = 2
    case JKClassArray = 3
    case JKClassDictionary = 4
    case JKClassNull = 5
}

enum ObjCEnum8 : Int {
    case JKManagedBufferOnStack = 1
    case JKManagedBufferOnHeap = 2
    case JKManagedBufferLocationMask = (0x3)
    case JKManagedBufferLocationShift = (0)
    static let JKManagedBufferMustFree:  = (1 << 2)
}

var JKManagedBufferFlags = JKFlags()

enum ObjCEnum9 : Int {
    case JKObjectStackOnStack = 1
    case JKObjectStackOnHeap = 2
    case JKObjectStackLocationMask = (0x3)
    case JKObjectStackLocationShift = (0)
    static let JKObjectStackMustFree:  = (1 << 2)
}

var JKObjectStackFlags = JKFlags()

enum ObjCEnum10 : Int {
    case JKTokenTypeInvalid = 0
    case JKTokenTypeNumber = 1
    case JKTokenTypeString = 2
    case JKTokenTypeObjectBegin = 3
    case JKTokenTypeObjectEnd = 4
    case JKTokenTypeArrayBegin = 5
    case JKTokenTypeArrayEnd = 6
    case JKTokenTypeSeparator = 7
    case JKTokenTypeComma = 8
    case JKTokenTypeTrue = 9
    case JKTokenTypeFalse = 10
    case JKTokenTypeNull = 11
    case JKTokenTypeWhiteSpace = 12
}

var JKTokenType = 0

// These are prime numbers to assist with hash slot probing.
enum ObjCEnum11 : Int {
    case JKValueTypeNone = 0
    case JKValueTypeString = 5
    case JKValueTypeLongLong = 7
    case JKValueTypeUnsignedLongLong = 11
    case JKValueTypeDouble = 13
}

var JKValueType = 0

enum ObjCEnum12 : Int {
    case JKEncodeOptionAsData = 1
    case JKEncodeOptionAsString = 2
    case JKEncodeOptionAsTypeMask = 0x7
    static let JKEncodeOptionCollectionObj:  = (1 << 3)
    static let JKEncodeOptionStringObj:  = (1 << 4)
    static let JKEncodeOptionStringObjTrimQuotes:  = (1 << 5)
}

var JKEncodeOptionType = 0

var JKHash = 0

var JKTokenCacheItem = structJKTokenCacheItem()

var JKTokenCache = structJKTokenCache()

var JKTokenValue = structJKTokenValue()

var JKParseToken = structJKParseToken()

var JKPtrRange = structJKPtrRange()

var JKObjectStack = structJKObjectStack()

var JKBuffer = structJKBuffer()

var JKConstBuffer = structJKConstBuffer()

var JKConstPtrRange = structJKConstPtrRange()

var JKRange = structJKRange()

var JKManagedBuffer = structJKManagedBuffer()

var JKFastClassLookup = structJKFastClassLookup()

var JKEncodeCache = structJKEncodeCache()

var JKEncodeState = structJKEncodeState()

var JKObjCImpCache = structJKObjCImpCache()

var JKHashTableEntry = structJKHashTableEntry()

id(NSNumberAllocImp)

id(NSNumberInitWithUnsignedLongLongImp)

id(JKClassFormatterIMP)

#if __BLOCKS__
typealias JKClassFormatterBlock = (formatObject: AnyObject) -> AnyObject
#endif

// This is a JSONKit private class.
class JKSerializer: NSObject {
    var encodeState: JKEncodeState!

#if __BLOCKS__
let JKSERIALIZER_BLOCKS_PROTO = id(^)(id object)
#else
let JKSERIALIZER_BLOCKS_PROTO = id
#endif
    class func serializeObject(object: AnyObject, options optionFlags: JKSerializeOptionFlags, encodeOption: JKEncodeOptionType, block: JKSERIALIZER_BLOCKS_PROTO, delegate: AnyObject, selector: Selector, error: NSError?) -> AnyObject {
    }

    func serializeObject(object: AnyObject, options optionFlags: JKSerializeOptionFlags, encodeOption: JKEncodeOptionType, block: JKSERIALIZER_BLOCKS_PROTO, delegate: AnyObject, selector: Selector, error: NSError?) -> AnyObject {
    }

    func releaseState() {
    }
}
var UTF32 = uint32_t()

/* at least 32 bits */
var UTF16: UInt16 = 0

/* at least 16 bits */
var UTF8: UInt8 = 0

/* typically 8 bits */
enum ConversionResult : Int {
    case conversionOK
    /* conversion successful */
    case sourceExhausted
    /* partial character in source, but hit end */
    case targetExhausted
    /* insuff. room in target for conversion */
    case sourceIllegal
}

let UNI_REPLACEMENT_CHAR = (0x0000FFFD as! UTF32)
let UNI_MAX_BMP = (0x0000FFFF as! UTF32)
let UNI_MAX_UTF16 = (0x0010FFFF as! UTF32)
let UNI_MAX_UTF32 = (0x7FFFFFFF as! UTF32)
let UNI_MAX_LEGAL_UTF32 = (0x0010FFFF as! UTF32)
let UNI_SUR_HIGH_START = (0xD800 as! UTF32)
let UNI_SUR_HIGH_END = (0xDBFF as! UTF32)
let UNI_SUR_LOW_START = (0xDC00 as! UTF32)
let UNI_SUR_LOW_END = (0xDFFF as! UTF32)
#if !defined(JK_FAST_TRAILING_BYTES)
let trailingBytesForUTF8 = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5]

#endif
let offsetsFromUTF8 = [0x00000000U, 0x00003080U, 0x000E2080U, 0x03C82080U, 0xFA082080U, 0x82082080U]

let firstByteMark = [0x00, 0x00, 0xC0, 0xE0, 0xF0, 0xF8, 0xFC]

//#define JK_AT_STRING_PTR(x)  (&((x)->stringBuffer.bytes.ptr[(x)->atIndex]))
//#define JK_END_STRING_PTR(x) (&((x)->stringBuffer.bytes.ptr[(x)->stringBuffer.bytes.length]))
var JKArrayCreate: JKArray!

var JKArrayInsertObjectAtIndex = Void()

var JKArrayReplaceObjectAtIndexWithObject = Void()

var JKArrayRemoveObjectAtIndex = Void()

var JKDictionaryCapacityForCount = 0

var JKDictionaryCreate: JKDictionary!

var JKDictionaryHashEntry: JKHashTableEntry!

var JKDictionaryCapacity = 0

var JKDictionaryResizeIfNeccessary = Void()

var JKDictionaryRemoveObjectWithEntry = Void()

var JKDictionaryAddObject = Void()

var JKDictionaryHashTableEntryForKey: JKHashTableEntry!

var JSONDecoderCleanup = Void()

var NSStringObjectFromJSONString: AnyObject!

var jk_managedBuffer_release = Void()

var jk_managedBuffer_setToStackBuffer = Void()

var jk_managedBuffer_resize = [UInt8]()

var jk_objectStack_release = Void()

var jk_objectStack_setToStackBuffer = Void()

var jk_objectStack_resize = 0

var jk_error = Void()

var jk_parse_string = 0

var jk_parse_number = 0

var jk_parse_is_newline = size_t()

var jk_parse_skip_newline = JK_STATIC_INLINE int()

var jk_parse_skip_whitespace = JK_STATIC_INLINE void()

var jk_parse_next_token = 0

var jk_error_parse_accept_or3 = Void()

var jk_create_dictionary

var jk_parse_dictionary

var jk_parse_array

var jk_object_for_token

var jk_cachedObjects

var jk_cache_age = JK_STATIC_INLINE void()

var jk_set_parsed_token = JK_STATIC_INLINE void()

var jk_encode_error = Void()

var jk_encode_printf = 0

var jk_encode_write = 0

var jk_encode_writePrettyPrintWhiteSpace = 0

var jk_encode_write1slow = 0

var jk_encode_write1fast = 0

var jk_encode_writen = 0

var jk_encode_object_hash = JK_STATIC_INLINE JKHash()

var jk_encode_updateCache = JK_STATIC_INLINE void()

var jk_encode_add_atom_to_buffer = 0

//#define jk_encode_write1(es, dc, f)  (JK_EXPECT_F(_jk_encode_prettyPrint) ? jk_encode_write1slow(es, dc, f) : jk_encode_write1fast(es, dc, f))
var jk_min = JK_STATIC_INLINE size_t()

var jk_max = JK_STATIC_INLINE size_t()

var jk_calculateHash = JK_STATIC_INLINE JKHash()

// JSONKit v1.4 used both a JKArray : NSArray and JKMutableArray : NSMutableArray, and the same for the dictionary collection type.
// However, Louis Gerbarg (via cocoa-dev) pointed out that Cocoa / Core Foundation actually implements only a single class that inherits from the 
// mutable version, and keeps an ivar bit for whether or not that instance is mutable.  This means that the immutable versions of the collection
// classes receive the mutating methods, but this is handled by having those methods throw an exception when the ivar bit is set to immutable.
// We adopt the same strategy here.  It's both cleaner and gets rid of the method swizzling hackery used in JSONKit v1.4.
// This is a workaround for issue #23 https://github.com/johnezang/JSONKit/pull/23
// Basically, there seem to be a problem with using +load in static libraries on iOS.  However, __attribute__ ((constructor)) does work correctly.
// Since we do not require anything "special" that +load provides, and we can accomplish the same thing using __attribute__ ((constructor)), the +load logic was moved here.
var JKArrayClass: AnyClass? = nil

var JKArrayInstanceSize = 0

var JKDictionaryClass: AnyClass? = nil

var JKDictionaryInstanceSize = 0

// For JSONDecoder...
var jk_NSNumberClass: AnyClass? = nil

var jk_NSNumberAllocImp: NSNumberAllocImp? = nil

var jk_NSNumberInitWithUnsignedLongLongImp: NSNumberInitWithUnsignedLongLongImp? = nil

func jk_collectionClassLoadTimeInitialization() {
    var: void jk_collectionClassLoadTimeInitialization
    [NSAutoreleasePool * pool[NSAutoreleasePool]]
    // Though technically not required, the run time environment at load time initialization may be less than ideal.
    self.JKArrayClass = objc_getClass("JKArray")
    self.JKArrayInstanceSize =
    16
    L, class_getInstanceSize(JKArrayClass))
    self.JKDictionaryClass = objc_getClass("JKDictionary")
    self.JKDictionaryInstanceSize =
    16
    L, class_getInstanceSize(JKDictionaryClass))
    // For JSONDecoder...
    self.jk_NSNumberClass = Int.self
    self.jk_NSNumberAllocImp = (Int.methodForSelector(#selector(self.alloc)) as! NSNumberAllocImp)
        // Hacktacular.  Need to do it this way due to the nature of class clusters.
    var temp_NSNumber = Int
    self.jk_NSNumberInitWithUnsignedLongLongImp = (temp_NSNumber.methodForSelector(#selector(self.initWithUnsignedLongLong)) as! NSNumberInitWithUnsignedLongLongImp)
    temp_NSNumber().release()
    temp_NSNumber = nil
    pool.release()
    pool = nil
}

// MARK: -
class JKArray: NSMutableArray, NSCopying, NSMutableCopying, NSFastEnumeration {
    var objects: AnyObject!
    var count = 0
    var capacity = 0
    var mutations = 0



    class func allocWithZone(zone: NSZone) -> AnyObject {
//#pragma unused(zone)
        NSException.raise(NSInvalidArgumentException, format: "*** - [%@ %@]: The %@ class is private to JSONKit and should not be used in this fashion.", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), NSStringFromClass(self.self))
        return (nil)
    }
    func nil() -> JKArray id objects NSUInteger count BOOL mutableCollection NSCParameterAssert objects!= {
    }
}
var array: JKArray? = nil

JK_EXPECT_T(()

// Directly allocate the JKArray instance via calloc.

var count = ()

var count = ()

JK_EXPECT_F(()

var L = ()

// Note: The caller is responsible for -retaining the object that is to be added.
func nil() -> void _JKArrayInsertObjectAtIndex JKArray array id newObject NSUInteger objectIndex NSCParameterAssert array!= {
}

var newObjects: AnyObject? = nil

var newObjects = ()

var L = ()

var NULL = ()

var newObject = ()

// Note: The caller is responsible for -retaining the object that is to be added.
func JKArrayReplaceObjectAtIndexWithObject(JKArray, NSUInteger objectIndex, id newObject) {
    NSCParameterAssert((array != nil) && (array!.objects != nil) && (array!.count <= array!.capacity) && (objectIndex < array!.count) && (array!.objects[objectIndex] != nil) && (newObject != nil))
    if !(array != nil) && (array!.objects != nil) && (objectIndex < array!.count) && (array!.objects[objectIndex] != nil) && (newObject != nil) {
        newObject
        return
    }
    CFRelease(array!.objects[objectIndex])
    array!.objects[objectIndex] = nil
    array!.objects[objectIndex] = newObject
}

func nil() -> void _JKArrayRemoveObjectAtIndex JKArray array NSUInteger objectIndex NSCParameterAssert array!= {
}

var NULL = ()

var NULL = ()

func dealloc() {
    if JK_EXPECT_T(objects != nil) {
        var atObject = 0
        for atObject in 0..<count {
            if JK_EXPECT_T(objects[atObject] != nil) {
                CFRelease(objects)
                objects[atObject] = nil
            }
        }
        free(objects)
        objects = nil
    }
    super.dealloc()
}

func count() {
    NSParameterAssert((objects != nil) && (count <= capacity))
    return (count)
}

func range() {
    NSParameterAssert((objects != nil) && (count <= capacity))
    if (objectsPtr == nil) && (NSMaxRange(range) > 0) {
        NSException.raise(NSRangeException, format: "*** -[%@ %@]: pointer to objects array is NULL but range length is %lu", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(NSMaxRange(range)))
    }
    if (range.location > count) || (NSMaxRange(range) > count) {
        NSException.raise(NSRangeException, format: "*** -[%@ %@]: index (%lu) beyond bounds (%lu)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(NSMaxRange(range)), UInt(count))
    }
#if !__clang_analyzer__
    memcpy(objectsPtr, objects + range.location, range.length * sizeof(AnyObject))
#endif
}

func objectIndex() {
    if objectIndex >= count {
        NSException.raise(NSRangeException, format: "*** -[%@ %@]: index (%lu) beyond bounds (%lu)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(objectIndex), UInt(count))
    }
    NSParameterAssert((objects != nil) && (count <= capacity) && (objects[objectIndex] != nil))
    return (objects[objectIndex])
}

func len() {
    (state != nil) && (stackbuf != nil) && (len > 0) && (objects != nil) && (count <= capacity)
    if  {

    }
    state.state == 0
}

var mutations = [UInt]()

var stackbuf = ()

var enumeratedCount = 0

func JK_EXPECT_T(len: enumeratedCount<) {
}

NSParameterAssert(objects)

func objectIndex() {
    if mutations == 0 {
        NSException.raise(NSInternalInconsistencyException, format: "*** -[%@ %@]: mutating method sent to immutable object", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if anObject == nil {
        NSException.raise(NSInvalidArgumentException, format: "*** -[%@ %@]: attempt to insert nil", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if objectIndex > count {
        var raise: NSException
        var format: NSRangeException
        "*** -[%@ %@]: index (%lu) beyond bounds (%lu)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(objectIndex), 
        var (: UInt
        1
    }
#if __clang_analyzer__
}

// Stupid clang analyzer...  Issue #19.
#else

#endif

var L = ()

func objectIndex() {
    if mutations == 0 {
        NSException.raise(NSInternalInconsistencyException, format: "*** -[%@ %@]: mutating method sent to immutable object", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if objectIndex >= count {
        NSException.raise(NSRangeException, format: "*** -[%@ %@]: index (%lu) beyond bounds (%lu)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(objectIndex), UInt(count))
    }
    JKArrayRemoveObjectAtIndex(self, objectIndex)
    mutations = (mutations == NSUIntegerMax) ? 1 : mutations + 1
}

func anObject() {
    if mutations == 0 {
        NSException.raise(NSInternalInconsistencyException, format: "*** -[%@ %@]: mutating method sent to immutable object", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if anObject == nil {
        NSException.raise(NSInvalidArgumentException, format: "*** -[%@ %@]: attempt to insert nil", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if objectIndex >= count {
        NSException.raise(NSRangeException, format: "*** -[%@ %@]: index (%lu) beyond bounds (%lu)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), UInt(objectIndex), UInt(count))
    }
#if __clang_analyzer__

}

// Stupid clang analyzer...  Issue #19.
#else

#endif

var L = ()

func zone() {
    NSParameterAssert((objects != nil) && (count <= capacity))
    return
    mutations == 0
}

func zone() {
    NSParameterAssert((objects != nil) && (count <= capacity))
    return ([objects])
}

// MARK: -
class JKDictionaryEnumerator: NSEnumerator {
    var collection: AnyObject!
    var nextObject = 0

    convenience override init(jKDictionary initDictionary: JKDictionary) {
        NSParameterAssert(initDictionary != nil)
        if (super.init()) == nil {
            return (nil)
        }
        if (collection = (CFRetain(initDictionary) as! AnyObject)) == nil {
            self
            return (nil)
        }
        return (self)
    }

    func allObjects() -> [AnyObject] {
        NSParameterAssert(collection != nil)
        var count = (collection as! [NSObject : AnyObject]).count
        var atObject = 0
        var objects = [AnyObject](count: count, repeatedValue: AnyObject())
        while (objects[atObject] = self.nextObject()!) != nil {
            NSParameterAssert(atObject < count)
            atObject += 1
        }
        return ([objects])
    }

    override func nextObject() -> AnyObject {
        NSParameterAssert((collection != nil) && (JKDictionaryHashEntry(collection) != nil))
        var entry = JKDictionaryHashEntry(collection)
        var capacity = JKDictionaryCapacity(collection)
        var returnObject: AnyObject? = nil
        if entry != nil {
            while (nextObject < capacity) && ((returnObject = entry[nextObject += 1].key) == nil) {
                /* ... */
            }
        }
        return (returnObject)
    }


    deinit {
        if collection != nil {
            CFRelease(collection)
            collection = nil
        }
        super.dealloc()
    }
}
// MARK: -
class JKDictionary: NSMutableDictionary, NSCopying, NSMutableCopying, NSFastEnumeration {
    var count = 0
    var capacity = 0
    var mutations = 0
    var entry: JKHashTableEntry!



    class func allocWithZone(zone: NSZone) -> AnyObject {
//#pragma unused(zone)
        NSException.raise(NSInvalidArgumentException, format: "*** - [%@ %@]: The %@ class is private to JSONKit and should not be used in this fashion.", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), NSStringFromClass(self.self))
        return (nil)
    }
        // These values are taken from Core Foundation CF-550 CFBasicHash.m.  As a bonus, they align very well with our JKHashTableEntry struct too.
    let jk_dictionaryCapacities = [0, 3, 7, 13, 23, 41, 71, 127, 191, 251, 383, 631, 1087, 1723, 2803, 4523, 7351, 11959, 19447, 31231, 50683, 81919, 132607, 214519, 346607, 561109, 907759, 1468927, 2376191, 3845119, 6221311, 10066421, 16287743, 26354171, 42641881, 68996069, 111638519, 180634607, 292272623, 472907251]
    func bottom() -> NSUInteger _JKDictionaryCapacityForCount NSUInteger count NSUInteger {
    }
}
func lround(floor) {
}

var L = ()

var L = ()

var mid = ()

func nil() -> void _JKDictionaryResizeIfNeccessary JKDictionary dictionary NSCParameterAssert dictionary!= {
}

var capacityForCount = 0

// resize
var oldCapacity = dictionary.capacity

#if !NS_BLOCK_ASSERTIONS
var oldCount = dictionary.count

#endif
var oldEntry = dictionary.entry

JK_EXPECT_F(()

var capacityForCount = ()

var L = ()

var idx = 0

var L = ()

var oldCapacity = ()

var L = ()

var NULL = ()

var NULL = ()

NSCParameterAssert(()

free(oldEntry)

var NULL = ()

func nil() -> JKDictionary id keys NSUInteger keyHashes id objects NSUInteger count BOOL mutableCollection NSCParameterAssert keys!= {
}

var dictionary: JKDictionary? = nil

JK_EXPECT_T(()

// Directly allocate the JKDictionary instance via calloc.

_JKDictionaryCapacityForCount(count)

var L = ()

JK_EXPECT_F(()

var idx = 0

var L = ()

var count = ()

var L = ()

func dealloc() {
    if JK_EXPECT_T(entry != nil) {
        var atEntry = 0
        for atEntry in 0..<capacity {
            if JK_EXPECT_T(entry[atEntry].key != nil) {
                CFRelease(entry[atEntry].key)
                entry[atEntry].key = nil
            }
            if JK_EXPECT_T(entry[atEntry].object! != nil) {
                CFRelease(entry[atEntry].object!)
                entry[atEntry].object! = nil
            }
        }
        free(entry)
        entry = nil
    }
    super.dealloc()
}

func JKDictionaryHashEntry(JKDictionary) -> JKHashTableEntry {
    NSCParameterAssert(dictionary != nil)
    return (dictionary!.entry)
}

func JKDictionaryCapacity(JKDictionary) -> Int {
    NSCParameterAssert(dictionary != nil)
    return (dictionary!.capacity)
}

func nil() -> void _JKDictionaryRemoveObjectWithEntry JKDictionary dictionary JKHashTableEntry entry NSCParameterAssert dictionary!= {
}

var NULL = ()

var NULL = ()

var L = ()

// In order for certain invariants that are used to speed up the search for a particular key, we need to "re-add" all the entries in the hash table following this entry until we hit a NULL entry.
var removeIdx = entry - dictionary!.entry
var idx = 0

NSCParameterAssert(()

var L = ()

var capacity = ()

var entryIdx = 0

var capacity = ()

var atEntry = dictionary!.entry[entryIdx]

var keyHash = atEntry.keyHash

var key = atEntry.key
var object = atEntry.object!

var L = ()

var NULL = ()

var NULL = ()

var addKeyEntry = keyHash % dictionary!.capacity
var addIdx = 0

var L = ()

var capacity = ()

var atAddEntry = dictionary!.entry[((addKeyEntry + addIdx) % dictionary!.capacity)]

NSCParameterAssert(()

var key = ()

var object = ()

var keyHash = ()

func nil() -> void _JKDictionaryAddObject JKDictionary dictionary NSUInteger keyHash id key id object NSCParameterAssert dictionary!= {
}

var keyEntry = keyHash % dictionary!.capacity
var idx = 0

var L = ()

var capacity = ()

var entryIdx = (keyEntry + idx) % dictionary!.capacity

var atEntry = dictionary!.entry[entryIdx]

NSCParameterAssert(()

var key = ()

var object = ()

var keyHash = ()

// We should never get here.  If we do, we -release the key / object because it's our responsibility.
CFRelease(key)

CFRelease(object)

func count() {
    return (count)
}

func nil() -> JKHashTableEntry JKDictionary dictionary id aKey NSCParameterAssert dictionary!= {
}

var keyHash = CFHash(aKey)
var keyEntry = (keyHash % dictionary!.capacity)
var idx = 0

var atEntry: JKHashTableEntry? = nil

var L = ()

var capacity = ()

// If the key was in the table, we would have found it by now.

func aKey() {
    NSParameterAssert((entry != nil) && (count <= capacity))
    var entryForKey = JKDictionaryHashTableEntryForKey(self, aKey)
    return ((entryForKey != nil) ? entryForKey.object! : nil)
}

func keys() {
    NSParameterAssert((entry != nil) && (count <= capacity))
    var atEntry = 0
    var arrayIdx = 0
    for atEntry in 0..<capacity {
        if JK_EXPECT_T(entry[atEntry].key != nil) {
            NSCParameterAssert((entry[atEntry].object! != nil) && (arrayIdx < count))
            if JK_EXPECT_T(keys != nil) {
                keys[arrayIdx] = entry[atEntry].key
            }
            if JK_EXPECT_T(objects != nil) {
                objects[arrayIdx] = entry[atEntry].object!
            }
            arrayIdx += 1
        }
    }
}

func len() {
    (state != nil) && (stackbuf != nil) && (len > 0) && (entry != nil) && (count <= capacity)
    if  {

    }
    state.state == 0
}

var mutations = [UInt]()

var stackbuf = ()

var enumeratedCount = 0

func JK_EXPECT_T(len: enumeratedCount<) {
}

JK_EXPECT_T(entry)

var key = ()

func keyEnumerator() {
    return (JKDictionaryEnumerator(jKDictionary: self))
}

func aKey() {
    if mutations == 0 {
        NSException.raise(NSInternalInconsistencyException, format: "*** -[%@ %@]: mutating method sent to immutable object", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if aKey == nil {
        NSException.raise(NSInvalidArgumentException, format: "*** -[%@ %@]: attempt to insert nil key", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if anObject == nil {
        NSException.raise(NSInvalidArgumentException, format: "*** -[%@ %@]: attempt to insert nil value (key: %@)", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__), aKey)
    }
    JKDictionaryResizeIfNeccessary(self)
#if !__clang_analyzer__
    aKey = aKey
    // Why on earth would clang complain that this -copy "might leak", 
    anObject =
}

// but this -retain doesn't!?
#endif // __clang_analyzer__

CFHash(aKey)

var L = ()

func aKey() {
    if mutations == 0 {
        NSException.raise(NSInternalInconsistencyException, format: "*** -[%@ %@]: mutating method sent to immutable object", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    if aKey == nil {
        NSException.raise(NSInvalidArgumentException, format: "*** -[%@ %@]: attempt to remove nil key", NSStringFromClass(self.self), NSStringFromSelector(__FUNCTION__))
    }
    var entryForKey = JKDictionaryHashTableEntryForKey(self, aKey)
    if entryForKey != nil {
        JKDictionaryRemoveObjectWithEntry(self, entryForKey)
        mutations = (mutations == NSUIntegerMax) ? 1 : mutations + 1
    }
}

func zone() {
    NSParameterAssert((entry != nil) && (count <= capacity))
    return
    mutations == 0
}

func zone() {
    NSParameterAssert((entry != nil) && (count <= capacity))
    return (self)
}

// MARK: -
func jk_min(size_t a, size_t b) -> JK_STATIC_INLINE size_t {
    return ((a < b) ? a : b)
}

func jk_max(size_t a, size_t b) -> JK_STATIC_INLINE size_t {
    return ((a > b) ? a : b)
}

func jk_calculateHash(JKHash currentHash, unsigned char c) -> JK_STATIC_INLINE JKHash {
    return ((currentHash << 5) + currentHash) + (c - 29) ^ (currentHash >> 19)
}

func jk_error() {
    NSCParameterAssert((parseState != nil) && (format != nil))
    var varArgsList: va_list
    va_start(varArgsList, format)
    var formatString = String(format: format, arguments: varArgsList)
    va_end(varArgsList)
#if false
    let lineStart: UInt8 = parseState.stringBuffer.bytes.ptr + parseState.lineStartIndex
    let lineEnd: UInt8 = lineStart
    let atCharacterPtr: UInt8? = nil
    for atCharacterPtr in lineStart..<JK_END_STRING_PTR(parseState) {
        lineEnd = atCharacterPtr
        if jk_parse_is_newline(parseState, atCharacterPtr) {

        }
    }
    var lineString = ""
    var carretString = ""
    if lineStart < JK_END_STRING_PTR(parseState) {
        lineString = String(bytes: lineStart, length: (lineEnd - lineStart), encoding: NSUTF8StringEncoding)
        carretString = String(format: "%*.*s^", Int(parseState.atIndex - parseState.lineStartIndex), Int(parseState.atIndex - parseState.lineStartIndex), " ")
    }
#endif
    if parseState.error == nil {
        parseState.error = NSError(domain: "JKErrorDomain", code: -1, userInfo: [
            NSLocalizedDescriptionKey : formatString,
            "JKAtIndexKey" : Int(parseState.atIndex),
            "JKLineNumberKey" : Int(parseState.lineNumber)
        ]
)
    }
}

// MARK: -
// MARK: Buffer and Object Stack management functions
func .JKManagedBufferMustFree() -> void jk_managedBuffer_release JKManagedBuffer managedBuffer managedBuffer-> flags& {
}

var NULL = ()

var JKManagedBufferMustFree = ()

var NULL = ()

var L = ()

var JKManagedBufferLocationMask = ()

func jk_managedBuffer_setToStackBuffer(JKManagedBuffer, UInt8, size_t length) {
    jk_managedBuffer_release(managedBuffer)
    managedBuffer.bytes.ptr = ptr
    managedBuffer.bytes.length = length
    managedBuffer.flags = (managedBuffer.flags & ~.JKManagedBufferLocationMask) | .JKManagedBufferOnStack
}

var ( = [UInt8]()

var roundedUpNewSize = newSize

NSCParameterAssert(()

var newBuffer: UInt8? = nil
var oldBuffer: UInt8 = managedBuffer.bytes.ptr

var malloc = [UInt8]()

var newBuffer = ()

var roundedUpNewSize = ()

NSCParameterAssert(()

var reallocf = [UInt8]()

var roundedUpNewSize = ()

func nil() -> void jk_objectStack_release JKObjectStack objectStack NSCParameterAssert objectStack!= {
}

var atIndex = 0

var L = ()

var index = ()

var NULL = ()

var NULL = ()

var L = ()

NSCParameterAssert(()

var NULL = ()

var NULL = ()

var NULL = ()

var JKObjectStackMustFree = ()

var NULL = ()

var NULL = ()

var NULL = ()

var L = ()

var JKObjectStackLocationMask = ()

func nil() -> void jk_objectStack_setToStackBuffer JKObjectStack objectStack void objects void keys CFHashCode cfHashes size_t count NSCParameterAssert objectStack!= {
}

jk_objectStack_release(objectStack)

var objects = ()

var keys = ()

var cfHashes = ()

var count = ()

var JKObjectStackOnStack = ()

#if !NS_BLOCK_ASSERTIONS
var idx = size_t()

var L = ()

var count = ()

var NULL = ()

var NULL = ()

var L = ()

func roundedUpNewCount() -> int jk_objectStack_resize JKObjectStack objectStack size_t newCount size_t {
}

var newCount = ()

var returnCode = 0

var newObjects = nil
var newKeys = nil

var newCFHashes: CFHashCode? = nil

NSCParameterAssert(()

var calloc

var nil)

var errorExit = ()

var

var calloc

var nil)

var errorExit = ()

var

var errorExit = ()

var newObjects = ()

var NULL = ()

var newKeys = ()

var NULL = ()

var newCFHashes = ()

var NULL = ()

var roundedUpNewCount = ()

NSCParameterAssert(()

var realloc

var nil)

var newObjects = ()

var NULL = ()

var errorExit = ()

var realloc

var nil)

var newKeys = ()

var NULL = ()

var errorExit = ()

var newCFHashes = ()

var NULL = ()

var errorExit = ()

#if !NS_BLOCK_ASSERTIONS
var idx = size_t()

var count = ()

var roundedUpNewCount = ()

var NULL = ()

var NULL = ()

var L = ()

#endif

var roundedUpNewCount = ()

free(newObjects)

var NULL = ()

free(newKeys)

var NULL = ()

free(newCFHashes)

var NULL = ()

////////////
// MARK: -
// MARK: Unicode related functions
func isValidCodePoint(UTF32) -> JK_STATIC_INLINE ConversionResult {
    var result = conversionOK
    var ch = u32CodePoint
    if JK_EXPECT_F(ch >= UNI_SUR_HIGH_START) && (JK_EXPECT_T(ch <= UNI_SUR_LOW_END)) {
        result = sourceIllegal
        ch = UNI_REPLACEMENT_CHAR
    }
    if JK_EXPECT_F(ch >= 0xFDD0U) && (JK_EXPECT_F(ch <= 0xFDEFU) || JK_EXPECT_F((ch & 0xFFFEU) == 0xFFFEU)) && JK_EXPECT_T(ch <= 0x10FFFFU) {
        result = sourceIllegal
        ch = UNI_REPLACEMENT_CHAR
    }
    if JK_EXPECT_F(ch == 0) {
        result = sourceIllegal
        ch = UNI_REPLACEMENT_CHAR
    }
        u32CodePoint = ch
    return (result)
}

func isLegalUTF8(UTF8, size_t length) -> Int {
    let srcptr = source + length
    var a: UTF8
    switch length {
        default:
            return (0)
    // Everything else falls through when "true"...
        case 4:
            if JK_EXPECT_F(((a = (srcptr -= 1)) < 0x80) || (a > 0xBF)) {
                return (0)
            }
        case 3:
            if JK_EXPECT_F(((a = (srcptr -= 1)) < 0x80) || (a > 0xBF)) {
                return (0)
            }
        case 2:
            if JK_EXPECT_F((a = (srcptr -= 1)) > 0xBF) {
                return (0)
            }
            switch source {
            // no fall-through in this inner switch
                case 0xE0:
                    if JK_EXPECT_F(a < 0xA0) {
                        return (0)
                    }
                case 0xED:
                    if JK_EXPECT_F(a > 0x9F) {
                        return (0)
                    }
                case 0xF0:
                    if JK_EXPECT_F(a < 0x90) {
                        return (0)
                    }
                case 0xF4:
                    if JK_EXPECT_F(a > 0x8F) {
                        return (0)
                    }
                default:
                    if JK_EXPECT_F(a < 0x80) {
                        return (0)
                    }
            }

        case 1:
            if JK_EXPECT_F((JK_EXPECT_T(source < 0xC2)) && JK_EXPECT_F(source >= 0x80)) {
                return (0)
            }
    }

    if JK_EXPECT_F(source > 0xF4) {
        return (0)
    }
    return (1)
}

func result() -> ConversionResult ConvertSingleCodePointInUTF8 UTF8 sourceStart UTF8 sourceEnd UTF8 nextUTF8 UTF32 convertedUTF32 ConversionResult {
}

var conversionOK = ()

let source = sourceStart

var ch = 0

#if !defined(JK_FAST_TRAILING_BYTES)
var extraBytesToRead: UInt16 = trailingBytesForUTF8[source]

#else
var extraBytesToRead: UInt16 = __builtin_clz(((source) ^ 0xff) << 25)

JK_EXPECT_F(()

var sourceIllegal = ()

var UNI_REPLACEMENT_CHAR = ()

var finished = ()

// The cases all fall through.

var source = ()

var ch = ()

func ConvertUTF32toUTF8(UTF32 u32CodePoint, UTF8, UTF8) -> ConversionResult {
    let byteMask = 0xBF
    let byteMark = 0x80
    var result = conversionOK
    var target = targetStart
    var ch = u32CodePoint
    var bytesToWrite: UInt16 = 0
    result = isValidCodePoint(ch)
    // Figure out how many bytes the result will require. Turn any illegally large UTF32 things (> Plane 17) into replacement chars.
    if ch < (0x80 as! UTF32) {
        bytesToWrite = 1
    }
    else if ch < (0x800 as! UTF32) {
        bytesToWrite = 2
    }
    else if ch < (0x10000 as! UTF32) {
        bytesToWrite = 3
    }
    else if ch <= UNI_MAX_LEGAL_UTF32 {
        bytesToWrite = 4
    }
    else {
        bytesToWrite = 3
        ch = UNI_REPLACEMENT_CHAR
        result = sourceIllegal
    }

    target += bytesToWrite
    if target > targetEnd {
        target -= bytesToWrite
        result = targetExhausted
    }
    switch bytesToWrite {
    // note: everything falls through.
        case 4:
            target -= 1 = (((ch | byteMark) & byteMask) as! UTF8)
            ch >>= 6
        case 3:
            target -= 1 = (((ch | byteMark) & byteMask) as! UTF8)
            ch >>= 6
        case 2:
            target -= 1 = (((ch | byteMark) & byteMask) as! UTF8)
            ch >>= 6
        case 1:
            target -= 1 = ((ch | firstByteMark[bytesToWrite]) as! UTF8)
    }

    target += bytesToWrite
        targetStart = target
    return (result)
}

func jk_string_add_unicodeCodePoint(JKParseState, uint32_t unicodeCodePoint, size_t, JKHash) -> JK_STATIC_INLINE int {
    var u8s = parseState.token.tokenBuffer.bytes.ptr[tokenBufferIdx]
    var result: ConversionResult
    if (result = ConvertUTF32toUTF8(unicodeCodePoint, u8s, (parseState.token.tokenBuffer.bytes.ptr + parseState.token.tokenBuffer.bytes.length))) != conversionOK {
        if result == targetExhausted {
            return (1)
        }
    }
    var utf8len = u8s - parseState.token.tokenBuffer.bytes.ptr[tokenBufferIdx]
    var nextIdx = (tokenBufferIdx) + utf8len
    while tokenBufferIdx < nextIdx {
        stringHash = jk_calculateHash(stringHash, parseState.token.tokenBuffer.bytes.ptr[(tokenBufferIdx) += 1])
    }
    return (0)
}

////////////
// MARK: -
// MARK: Decoding / parsing / deserializing functions
func nil() -> int jk_parse_string JKParseState parseState NSCParameterAssert parseState!= {
}

JK_AT_STRING_PTR(parseState)

JK_END_STRING_PTR(parseState)

let stringStart: UInt8 = JK_AT_STRING_PTR(parseState) + 1

let endOfBuffer: UInt8 = JK_END_STRING_PTR(parseState)

let atStringCharacter: UInt8 = stringStart

var tokenBuffer: UInt8 = parseState.token.tokenBuffer.bytes.ptr

var tokenStartIndex = parseState.atIndex

var tokenBufferIdx = 0

var onlySimpleString = 1
var stringState = .JSONStringStateStart

var escapedUnicode1: UInt16 = 0
var escapedUnicode2: UInt16 = 0

var escapedUnicodeCodePoint = 0

var stringHash = JK_HASH_INIT

var currentChar = 0

/* XXX Add error message */
var JSONStringStateError = ()

var finishedParsing = ()

JK_EXPECT_F(()

let nextValidCharacter: UInt8? = nil

var u32ch = 0

var result = ConversionResult()

JK_EXPECT_F(()

func NSCParameterAssert(JK_AT_STRING_PTR) {
}

JK_END_STRING_PTR(parseState)

var JSONStringStateFinished = ()

var finishedParsing = ()

var JSONStringStateParsing = ()

JK_EXPECT_F(())

var JSONStringStateError = ()

var finishedParsing = ()

var slowMatch = ()

func JK_EXPECT_F(L: currentChar<0x20U) {
    jk_error(parseState, "Invalid character < 0x20 found in string: 0x%2.2x.", currentChar)
    stringState = .JSONStringStateError
}

var JSONStringStateError = ()

var finishedParsing = ()

func NSCParameterAssert(length: tokenBufferIdx< parseState-> token. tokenBuffer. bytes.) {
    var currentChar = (atStringCharacter)
    var escapedChar: UInt
    if JK_EXPECT_T(stringState == .JSONStringStateParsing) {
        if  != nil {

        }
        currentChar >= 0x20U
    }
}

func JK_EXPECT_T(currentChar<) {
}

// Not a UTF8 sequence

var JSONStringStateFinished = ()

var finishedParsing = ()

var JSONStringStateEscape = ()

var currentChar = ()

// UTF8 sequence
let nextValidCharacter: UInt8? = nil

var u32ch = 0

var result = ConversionResult()

JK_EXPECT_F(()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var atStringCharacter = ()

// currentChar < 0x20

var JSONStringStateError = ()

var finishedParsing = ()

// stringState != JSONStringStateParsing
var isSurrogate = 1

var JSONStringStateEscapedUnicode1 = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var parsedEscapedChar = ()

var JSONStringStateParsing = ()

var escapedChar = ()

var JSONStringStateError = ()

var finishedParsing = ()

var hexValue: UInt16 = 0

var parsedHex = ()

var parsedHex = ()

var parsedHex = ()

var hexValue = ()

var hexValue = ()

var JSONStringStateEscapedNeedEscapeForSurrogate = ()

var UNI_REPLACEMENT_CHAR = ()

var JSONStringStateError = ()

var finishedParsing = ()

var escapedUnicode1 = ()

var UNI_REPLACEMENT_CHAR = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateEscapedNeedEscapedUForSurrogate = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateEscapedUnicodeSurrogate1 = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

var JSONStringStateError = ()

var finishedParsing = ()

NSCParameterAssert(()

var tokenStartIndex = ()

JK_EXPECT_T(onlySimpleString)

NSCParameterAssert(()

var L = ()

var ptr = ()

var tokenBufferIdx = ()

var stringHash = ()

var JKValueTypeString = ()

func nil() -> int jk_parse_number JKParseState parseState NSCParameterAssert parseState!= {
}

JK_AT_STRING_PTR(parseState)

JK_END_STRING_PTR(parseState)

let numberStart: UInt8 = JK_AT_STRING_PTR(parseState)

let endOfBuffer: UInt8 = JK_END_STRING_PTR(parseState)

let atNumberCharacter: UInt8? = nil

var numberState = .JSONNumberStateWholeNumberStart
var isFloatingPoint = 0
var isNegative = 0
var backup = 0

var startingIndex = parseState.atIndex

var numberStart = ()

func JK_EXPECT_T(endOfBuffer: atNumberCharacter<) {
}

var currentChar = UInt(atNumberCharacter)
var lowerCaseCC = currentChar | 0x20U

var JSONNumberStateWholeNumberMinus = ()

var JSONNumberStateWholeNumberZero = ()

var JSONNumberStateWholeNumber = ()

/* XXX Add error message */
var JSONNumberStateError = ()

var JSONNumberStateExponentPlusMinus = ()

/* XXX Add error message */
var JSONNumberStateError = ()

var JSONNumberStateFractionalNumber = ()

var JSONNumberStateExponent = ()

var JSONNumberStateFractionalNumberStart = ()

var JSONNumberStateExponentStart = ()

var JSONNumberStateFinished = ()

/* XXX Add error message */
var JSONNumberStateError = ()

var startingIndex = ()

var backup = ()

var ptr = ()

var L = unsigned char numberTempBuf parseState-> token. tokenPtrRange. length+4U()

var endOfNumber: UInt8? = nil

// Treat "-0" as a floating point number, which is capable of representing negative zeros.

JK_EXPECT_F(numberTempBuf)

JK_EXPECT_F(isNegative)

strtod(()

let numberTempBuf: CChar!
let ( = CChar()

var endOfNumber): CChar!

// strtod is documented to return U+2261 (identical to) 0.0 on an underflow error (along with setting errno to ERANGE).

var JKValueTypeDouble = ()

let parseState = [UInt8]()

var doubleValue = ()

strtoll(()

let numberTempBuf: CChar!
let ( = CChar()

var endOfNumber: CChar!
var ) = CChar()

var JKValueTypeLongLong = ()

let parseState = [UInt8]()

var longLongValue = ()

var longLongValue = ()

strtoull(()

let numberTempBuf: CChar!
let ( = CChar()

var endOfNumber: CChar!
var ) = CChar()

var JKValueTypeUnsignedLongLong = ()

let parseState = [UInt8]()

var unsignedLongLongValue = ()

var unsignedLongLongValue = ()

var JSONNumberStateError = ()

// see above for == 0.0.

var JSONNumberStateError = ()

var hashIndex = 0

var L = ()

var length = ()

JK_EXPECT_T(())

func jk_set_parsed_token(JKParseState, UInt8, size_t length, JKTokenType type, size_t advanceBy) -> JK_STATIC_INLINE void {
    parseState.token.tokenPtrRange.ptr = ptr
    parseState.token.tokenPtrRange.length = length
    parseState.token.type = type
    parseState.atIndex += advanceBy
}

func nil() -> size_t jk_parse_is_newline JKParseState parseState unsigned char atCharacterPtr NSCParameterAssert parseState!= {
}

JK_END_STRING_PTR(parseState)

let endOfStringPtr: UInt8 = JK_END_STRING_PTR(parseState)

JK_EXPECT_F(())

JK_EXPECT_F(())

JK_EXPECT_T(())

JK_EXPECT_F(())

JK_EXPECT_F(())

func newlineAdvanceAtIndex() -> JK_STATIC_INLINE int jk_parse_skip_newline JKParseState parseState size_t {
}

var L = ()

JK_EXPECT_F(()

var L = ()

func jk_parse_skip_whitespace(JKParseState) -> JK_STATIC_INLINE void {
#if !__clang_analyzer__
    NSCParameterAssert((parseState != nil) && (JK_AT_STRING_PTR(parseState) <= JK_END_STRING_PTR(parseState)))
    let atCharacterPtr: UInt8? = nil
    let endOfStringPtr: UInt8 = JK_END_STRING_PTR(parseState)
    atCharacterPtr = JK_AT_STRING_PTR(parseState)
    while (JK_EXPECT_T((atCharacterPtr = JK_AT_STRING_PTR(parseState)) < endOfStringPtr)) {
        if ((atCharacterPtr + 0) == " ") || ((atCharacterPtr + 0) == "\t") {

        }
        if jk_parse_skip_newline(parseState) {

        }
        if parseState.parseOptionFlags & .JKParseOptionComments {
            if (JK_EXPECT_F((atCharacterPtr + 0) == "/")) && (JK_EXPECT_T((atCharacterPtr + 1) < endOfStringPtr)) {
                if (atCharacterPtr + 1) == "/" {
                    parseState.atIndex += 1
                    atCharacterPtr = JK_AT_STRING_PTR(parseState)
                    while (JK_EXPECT_T((atCharacterPtr = JK_AT_STRING_PTR(parseState)) < endOfStringPtr)) {
                        if jk_parse_skip_newline(parseState) {

                        }
                        parseState.atIndex += 1
                    }
                }
                if (atCharacterPtr + 1) == "*" {
                    parseState.atIndex += 1
                    atCharacterPtr = JK_AT_STRING_PTR(parseState)
                    while (JK_EXPECT_T((atCharacterPtr = JK_AT_STRING_PTR(parseState)) < endOfStringPtr)) {
                        if jk_parse_skip_newline(parseState) {

                        }
                        if ((atCharacterPtr + 0) == "*") && ((atCharacterPtr + 1) < endOfStringPtr) && ((atCharacterPtr + 1) == "/") {
                            parseState.atIndex += 1
                        }
                        parseState.atIndex += 1
                    }
                }
            }
        }
        parseState.atIndex += 1
    }
#endif
}

func nil() -> int jk_parse_next_token JKParseState parseState NSCParameterAssert parseState!= {
}

JK_AT_STRING_PTR(parseState)

JK_END_STRING_PTR(parseState)

let atCharacterPtr: UInt8? = nil

let endOfStringPtr: UInt8 = JK_END_STRING_PTR(parseState)

var currentCharacter: UInt8 = 0

var stopParsing = 0

var atIndex = ()

var lineNumber = ()

var lineStartIndex = ()

jk_parse_skip_whitespace(parseState)

JK_AT_STRING_PTR(parseState)

JK_EXPECT_T(()

var atCharacterPtr = ()

JK_EXPECT_T(()

JK_EXPECT_T(()

JK_EXPECT_T(())

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

/* XXX Add error message */

JK_EXPECT_T(())

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

/* XXX Add error message */

JK_EXPECT_T(())

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

JK_EXPECT_T(atCharacterPtr)

/* XXX Add error message */

/* XXX Add error message */
JK_EXPECT_F(stopParsing)

func jk_error_parse_accept_or3(JKParseState, int state, String, String, String) {
    var acceptStrings = [String](count: 16, repeatedValue: "")
    var acceptIdx = 0
    if state & .JKParseAcceptValue {
        acceptStrings[acceptIdx += 1] = or1String
    }
    if state & .JKParseAcceptComma {
        acceptStrings[acceptIdx += 1] = or2String
    }
    if state & .JKParseAcceptEnd {
        acceptStrings[acceptIdx += 1] = or3String
    }
    if acceptIdx == 1 {
        jk_error(parseState, "Expected %@, not '%*.*s'", acceptStrings[0], Int(parseState.token.tokenPtrRange.length), Int(parseState.token.tokenPtrRange.length), parseState.token.tokenPtrRange.ptr)
    }
    else if acceptIdx == 2 {
        jk_error(parseState, "Expected %@ or %@, not '%*.*s'", acceptStrings[0], acceptStrings[1], Int(parseState.token.tokenPtrRange.length), Int(parseState.token.tokenPtrRange.length), parseState.token.tokenPtrRange.ptr)
    }
    else if acceptIdx == 3 {
        jk_error(parseState, "Expected %@, %@, or %@, not '%*.*s", acceptStrings[0], acceptStrings[1], acceptStrings[2], Int(parseState.token.tokenPtrRange.length), Int(parseState.token.tokenPtrRange.length), parseState.token.tokenPtrRange.ptr)
    }

}

var ()

var startingObjectIndex = parseState.objectStack.index

var arrayState = .JKParseAcceptValueOrEnd
var stopParsing = 0

var parsedArray = nil

JK_EXPECT_T(()